/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.panel.RobotView3DPanel;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.boundaries.externalapi.BoundariesPresenter;
import com.ur.safety.boundaries.externalapi.SafetyBoundaryVisualization;
import com.ur.safety.boundaries.externalapi.ToolOrientationVisualizationStrategy;
import com.ur.safety.boundaries.infrastructure.BoundaryPlanesVisualizer;
import com.ur.safety.boundaries.infrastructure.ToolDirectionVisualizer;
import com.ur.safety.boundaries.infrastructure.ToolOrientationBoundaryVisualizer;
import com.ur.safety.toolorientation.externalapi.ToolOrientationPresenter;
import com.ur.safety.toolorientation.externalapi.ToolOrientationVisualization;
import com.ur.swing.ViewContext;
import java.util.Arrays;
import javax.inject.Inject;
import javax.vecmath.Vector3d;

public class Boundaries3DViewPanel
extends RobotView3DPanel
implements SafetyBoundaryVisualization,
ToolOrientationVisualization {
    private final SafetySettingsLookupService safetySettingsLookupService;
    private final ToolOrientationVisualizationStrategy toolOrientationVisualizationStrategy;
    private final ToolDirectionVisualizer toolDirectionVisualizer;
    private final ToolOrientationBoundaryVisualizer toolOrientationVisualizer;
    private final BoundaryPlanesVisualizer boundaryPlanesVisualizer;
    private ToolOrientationLimit displayedToolOrientationLimit;

    @Inject
    private Boundaries3DViewPanel(SafetySettingsLookupService safetySettingsLookupService, ToolOrientationVisualizationStrategy toolOrientationVisualizationStrategy, ToolDirectionVisualizer toolDirectionVisualizer, ToolOrientationBoundaryVisualizer toolOrientationBoundaryVisualizer, BoundaryPlanesVisualizer boundaryPlanesVisualizer, RobotCanvas3DFactory robotCanvas3DFactory, ControllerInterface controllerInterface, ViewContext viewContext) {
        super(robotCanvas3DFactory, controllerInterface, viewContext, "Boundaries 3D Canvas");
        this.safetySettingsLookupService = safetySettingsLookupService;
        this.toolOrientationVisualizationStrategy = toolOrientationVisualizationStrategy;
        this.toolDirectionVisualizer = toolDirectionVisualizer;
        this.toolOrientationVisualizer = toolOrientationBoundaryVisualizer;
        this.boundaryPlanesVisualizer = boundaryPlanesVisualizer;
        if (robotCanvas3DFactory.hasActualCanvas()) {
            boundaryPlanesVisualizer.preInitialize();
            toolOrientationBoundaryVisualizer.preInitialize();
            toolDirectionVisualizer.preInitialize();
            this.robotCanvas3D.addNodeToScene(boundaryPlanesVisualizer.getElementNode());
            this.robotCanvas3D.addNodeToScene(this.toolOrientationVisualizer.getElementNode());
            this.robotCanvas3D.addNodeToScene(toolDirectionVisualizer.getElementNode());
        }
        this.robotCanvas3D.alwaysRun(new Runnable(){
            private RobotState lastRobotState;

            @Override
            public void run() {
                RobotState robotState = RobotState.getLatestRobotState();
                if (robotState == this.lastRobotState) {
                    return;
                }
                this.lastRobotState = robotState;
                if (Boundaries3DViewPanel.this.toolOrientationVisualizer.isDisplayingLimit() && robotState.hasReceivedPositionData) {
                    Boundaries3DViewPanel.this.visualize(Boundaries3DViewPanel.this.displayedToolOrientationLimit, Boundaries3DViewPanel.this.getToolPose(robotState));
                }
                Boundaries3DViewPanel.this.robotCanvas3D.setJointAngleVector(robotState.jointPosition);
            }
        });
        this.getRobotCanvas3D().showStaticElements(Arrays.asList(VisualizerElementType.PAYLOAD_COG, VisualizerElementType.TCP));
    }

    private Pose6d getToolPose(RobotState robotState) {
        return this.toolOrientationVisualizationStrategy.getToolOrientationLimitPose(this.safetySettingsLookupService.getSafetySetup(), robotState.tool, robotState.tcpOffset);
    }

    @Override
    public void updateBoundaryPlanes(BoundariesPresenter.UIBoundary selectedBoundary, Iterable<BoundariesPresenter.UIBoundary> activeUIBoundaries, Iterable<BoundariesPresenter.UIBoundary> unusedUIBoundaries) {
        if (activeUIBoundaries != null) {
            for (BoundariesPresenter.UIBoundary each : activeUIBoundaries) {
                this.updateBoundaryPlane(each, selectedBoundary == each);
            }
            for (BoundariesPresenter.UIBoundary each : unusedUIBoundaries) {
                this.updateBoundaryPlane(each, selectedBoundary == each);
            }
        }
    }

    private void updateBoundaryPlane(BoundariesPresenter.UIBoundary plane, boolean isSelected) {
        if ((plane.isVisible() || isSelected) && plane.isDefined()) {
            this.visualizeBoundary(plane, isSelected);
        } else {
            this.clearVisualization(plane);
        }
    }

    @Override
    public void updateToolOrientation(ToolOrientationPresenter.UIToolOrientation uiToolOrientation) {
        if (uiToolOrientation.isDefined()) {
            this.visualizeToolOrientationLimit(uiToolOrientation.asToolOrientationLimit());
        } else {
            this.clearToolOrientationLimitVisualization();
        }
    }

    @Override
    public void visualizeBoundary(BoundariesPresenter.UIBoundary boundary, boolean highlightPlane) {
        this.visualizePlane(boundary.asBoundaryPlane(), boundary.getPlaneIndex(), highlightPlane);
    }

    @Override
    public void clearVisualization(BoundariesPresenter.UIBoundary boundary) {
        this.clearPlaneVisualization(boundary.getPlaneIndex());
    }

    public void visualizePlane(BoundaryPlane boundaryPlane, int plane, boolean highlightPlane) {
        this.boundaryPlanesVisualizer.drawPlane(boundaryPlane, plane, highlightPlane, false);
    }

    public void clearPlaneVisualization(int plane) {
        this.boundaryPlanesVisualizer.clearPlaneVisualization(plane);
    }

    public void visualizeToolOrientationLimit(ToolOrientationLimit toolOrientationLimit) {
        if (toolOrientationLimit != null) {
            this.robotCanvas3D.addQueue((Runnable)new UpdateGraphicsRunnable(toolOrientationLimit));
        }
    }

    public void clearToolOrientationLimitVisualization() {
        this.robotCanvas3D.addQueue((Runnable)new ClearVisualizationRunnable());
    }

    private void visualize(ToolOrientationLimit toolOrientationLimit, Pose6d toolPose) {
        if (toolOrientationLimit != null) {
            this.toolOrientationVisualizer.showToolOrientationLimit(toolOrientationLimit, toolPose.getPos(), false);
            this.toolDirectionVisualizer.display(toolPose);
        }
    }

    private class ClearVisualizationRunnable
    implements Runnable {
        private ClearVisualizationRunnable() {
        }

        @Override
        public void run() {
            Boundaries3DViewPanel.this.toolOrientationVisualizer.clearVisualization();
            Boundaries3DViewPanel.this.toolDirectionVisualizer.clearVisualization();
        }
    }

    private class UpdateGraphicsRunnable
    implements Runnable {
        private ToolOrientationLimit toolOrientationLimit;

        public UpdateGraphicsRunnable(ToolOrientationLimit toolOrientationLimit) {
            this.toolOrientationLimit = toolOrientationLimit;
        }

        @Override
        public void run() {
            RobotState robotState = RobotState.getLatestRobotState();
            if (robotState.hasReceivedPositionData) {
                Boundaries3DViewPanel.this.visualize(this.toolOrientationLimit, Boundaries3DViewPanel.this.getToolPose(robotState));
            } else {
                Boundaries3DViewPanel.this.toolOrientationVisualizer.showToolOrientationLimit(this.toolOrientationLimit, new Vector3d(), false);
            }
            Boundaries3DViewPanel.this.displayedToolOrientationLimit = this.toolOrientationLimit;
        }
    }
}

