/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.safety.position.ElbowPosition;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.polyscope.viewfacade.lang.ShowIcon;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvasbehavior.UpdateZoomInCanvas;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorWrapper;
import com.ur.polyscope.visualizer.canvasbehavior.ZoomRenderer;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.safety.Safety;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.boundaries.externalapi.BoundariesPresenter;
import com.ur.safety.boundaries.externalapi.BoundariesView;
import com.ur.safety.boundaries.externalapi.BoundaryInputBinder;
import com.ur.safety.boundaries.externalapi.BoundaryPlaneProperties;
import com.ur.safety.boundaries.externalapi.ElementDefinitionState;
import com.ur.safety.boundaries.infrastructure.Boundaries3DViewPanel;
import com.ur.safety.boundaries.infrastructure.BoundariesPanel;
import com.ur.safety.boundaries.infrastructure.BoundaryPlaneRenderer;
import com.ur.safety.boundaries.infrastructure.ElbowSphereVisualizer;
import com.ur.safety.util.domain.UpdateParentWithFormState;
import com.ur.safety.util.infrastructure.SelectFeature;
import com.ur.safety.util.infrastructure.SelectSafetyLimit;
import com.ur.safety.workpiece.infrastructure.EditNameView;
import com.ur.safety.workpiece.infrastructure.NameLengthValidationStrategy;
import com.ur.swing.FormBuilder;
import com.ur.swing.InputView;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.number.NumberField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

@Singleton
public class BoundariesPanelImpl
extends BoundariesPanel
implements BoundariesView {
    public static final String PLANES_PANEL = "PlanesPanel." + BoundariesPanelImpl.class.getSimpleName();
    public static final String SAFETY_PLANES_LIST = "SafetyPlanesList." + BoundariesPanelImpl.class.getSimpleName();
    public static final String FEATURES_COMBO_BOX = "FeaturesComboBox." + BoundariesPanelImpl.class.getSimpleName();
    public static final String DEVIATION_INPUT = "DeviationInputText." + BoundariesPanelImpl.class.getSimpleName();
    public static final String SAFETY_MODES_COMBO_BOX = "SafetyModesComboBox." + BoundariesPanelImpl.class.getSimpleName();
    public static final String DISPLACEMENT_FIELD = "DISPLACEMENT." + BoundariesPanelImpl.class.getSimpleName();
    public static final String G5_BOUNDARIES_PANEL = "G5BoundariesPanel" + BoundariesPanelImpl.class.getSimpleName();
    public static final String SHOW_BOUNDARY_LIMITS_ACTION = "ShowBoundaryLimitsAction." + BoundariesPanelImpl.class.getSimpleName();
    public static final String RESTRICT_TOOL_FLANGE_CHECKBOX = "RestrictToolFlangeCheckbox." + BoundariesPanelImpl.class.getSimpleName();
    public static final Color BETWEEN_CARD_COLOR = UIManager.getColor("CardPanel.background");
    private final UpdateParentWithFormState formStatus;
    private final BoundariesPresenter presenter;
    private final BoundaryInputBinder binder;
    private final SafetyTextResource text;
    private final BoundaryPlaneRenderer planeRenderer;
    private final Boundaries3DViewPanel view3DPanel;
    private final ElbowSphereVisualizer elbowSphereVisualizer;
    private RenamePlane renamePlane;
    private SafetyPlanes safetyPlanes;
    private SelectFeature planeFeatures;
    private SelectSafetyLimit planeSafetyMode;
    private SetDisplacement displacement;
    private JCheckBox checkElbow;
    private JCheckBox checkFlange;
    private JPanel planesPanel;
    private final HelpIdAssigner helpIdAssigner;
    private FeaturesLookup featuresLookup;

    @Inject
    public BoundariesPanelImpl(BoundariesPresenter presenter, BoundaryInputBinder binder, ViewContext view, @Safety ShowIcon showIconForParent, BoundaryPlaneRenderer planeRenderer, Boundaries3DViewPanel view3DPanel, Provider<ElbowPosition> elbowPositionProvider, FeaturesLookup featuresLookup) {
        this.presenter = presenter;
        this.binder = binder;
        this.text = (SafetyTextResource)view.getTextResource(SafetyTextResource.class);
        this.planeRenderer = planeRenderer;
        this.formStatus = new UpdateParentWithFormState(showIconForParent, this);
        this.view3DPanel = view3DPanel;
        this.elbowSphereVisualizer = new ElbowSphereVisualizer(elbowPositionProvider);
        this.helpIdAssigner = view.getHelpIdAssigner();
        this.featuresLookup = featuresLookup;
        this.setName(G5_BOUNDARIES_PANEL);
        this.initComponents(view);
        presenter.setView(this);
    }

    @Override
    public void activate() {
        this.view3DPanel.setActive(true);
        this.presenter.set3DView(this.view3DPanel);
        this.presenter.activate();
    }

    @Override
    public void deactivate() {
        this.view3DPanel.setActive(false);
        this.presenter.deactivate();
    }

    private void initComponents(ViewContext view) {
        WidgetFactory widgetFactory = view.createWidgetFactory();
        this.setBackground(BETWEEN_CARD_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout(5, 5));
        this.safetyPlanes = new SafetyPlanes(widgetFactory);
        this.renamePlane = new RenamePlane(widgetFactory, this.text);
        this.planeFeatures = new SelectFeature(this.presenter, widgetFactory, this.text);
        this.planeSafetyMode = new SelectSafetyLimit(this.presenter, widgetFactory, SafetyLimitMode.valuesForPlane());
        this.displacement = new SetDisplacement(this.binder);
        this.checkElbow = widgetFactory.createCheckBox(this.text.safetyHeaderRestrictElbow());
        this.checkElbow.addActionListener(this.restrictElbowListener());
        this.checkFlange = widgetFactory.createCheckBox(this.text.safetyHeaderRestrictFlange());
        this.checkFlange.addActionListener(this.restrictFlangeListener());
        this.checkFlange.setName(RESTRICT_TOOL_FLANGE_CHECKBOX);
        JPanel boundaryPlaneProperties = view.createFormBuilder().component((JComponent)this.renamePlane.panel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().end().components((FormBuilder.Components)this.planeFeatures, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).label(this.text.safetyHeaderRestrictions(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().components((FormBuilder.Components)this.planeSafetyMode, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).label(this.text.safetyHeaderDisplacement(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.displacement.field, new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.checkElbow, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.checkFlange, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().getPanel();
        boundaryPlaneProperties.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.planesPanel = new JPanel(new BorderLayout());
        this.planesPanel.add(this.safetyPlanes.list);
        this.planesPanel.setName(PLANES_PANEL);
        this.planesPanel.setBorder((Border)new CardBorder(this.text.safetyTabPlanes()));
        JPanel propertiesPanel = new JPanel(new BorderLayout());
        propertiesPanel.add((Component)boundaryPlaneProperties, "Center");
        propertiesPanel.setBorder((Border)new CardBorder(this.text.properties()));
        propertiesPanel.setPreferredSize(new Dimension(320, 350));
        JPanel rightSideView = new JPanel(new BorderLayout(0, 5));
        rightSideView.setMinimumSize(new Dimension(320, -1));
        rightSideView.setPreferredSize(new Dimension(320, -1));
        rightSideView.setBackground(BETWEEN_CARD_COLOR);
        rightSideView.add((Component)this.planesPanel, "Center");
        rightSideView.add((Component)propertiesPanel, "South");
        this.add((Component)rightSideView, "East");
        RobotCanvas3D canvas3D = this.view3DPanel.getRobotCanvas3D();
        canvas3D.showElements(Arrays.asList(VisualizerElementType.PAYLOAD_COG, VisualizerElementType.TCP), Collections.singleton(this.elbowSphereVisualizer));
        this.add((Component)((Object)this.view3DPanel), "Center");
        ViewBehaviorWrapper wrapper = new ViewBehaviorWrapper(this.featuresLookup);
        canvas3D.addJ3DComponent((J3DComponent)new ZoomRenderer(canvas3D.getComponent(), (ViewBehaviorHolder)wrapper));
        canvas3D.alwaysRun((Runnable)new UpdateZoomInCanvas((ViewBehaviorHolder)wrapper));
        this.view3DPanel.setBorder((Border)new CardBorder(this.text.Robot()));
        this.helpIdAssigner.assignHelpId((JComponent)this.planesPanel, "gui:installation_safety_boundaries_select_boundary");
        this.helpIdAssigner.assignHelpId((JComponent)((Object)this.view3DPanel), "gui:installation_safety_boundaries_3d_view");
        this.helpIdAssigner.assignHelpId((JComponent)propertiesPanel, "gui:installation_safety_safety_plane_configuration");
    }

    private ActionListener restrictElbowListener() {
        return e -> this.presenter.setElbowRestricted(this.checkElbow.isSelected());
    }

    private ActionListener restrictFlangeListener() {
        return e -> this.presenter.setFlangeRestricted(this.checkFlange.isSelected());
    }

    @Override
    public void setBoundariesList(Iterable<BoundariesPresenter.UIBoundary> safetyPlanes) {
        this.safetyPlanes.setAvailablePlanes(safetyPlanes);
        this.updatePlanesCounter();
    }

    @Override
    public void addSafetyPlane(BoundariesPresenter.UIBoundary safetyPlane) {
        this.safetyPlanes.addSafetyPlane(safetyPlane);
        this.updatePlanesCounter();
    }

    @Override
    public void setSelectedSafetyPlane(BoundariesPresenter.UIBoundary selectedUIBoundary) {
        this.safetyPlanes.setSelectSafetyPlane(selectedUIBoundary);
        this.updatePlanesCounter();
    }

    private void updatePlanesCounter() {
        int countOfPlanes = this.safetyPlanes.getSafetyPlaneCount();
        this.planesPanel.setBorder((Border)new CardBorder(String.valueOf(this.text.safetyTabPlanes()) + " (" + countOfPlanes + " of 8)"));
    }

    @Override
    public void setPlaneProperties(BoundaryPlaneProperties boundaryPlaneProperties) {
        this.renamePlane.setName(boundaryPlaneProperties.getName());
        this.planeFeatures.setSelection(boundaryPlaneProperties.getFeature());
        this.planeSafetyMode.setSafetyMode(boundaryPlaneProperties.getSafetyLimitMode());
        this.displacement.setValue(boundaryPlaneProperties.getDisplacement());
        if (boundaryPlaneProperties.getSafetyLimitMode() == SafetyLimitMode.TRIGGER) {
            this.displacement.setTriggerBoundaryDisplacement();
        } else {
            this.displacement.setPlaneBoundaryDisplacement();
        }
        this.checkElbow.setSelected(boundaryPlaneProperties.isElbowChecked());
        this.checkFlange.setSelected(boundaryPlaneProperties.isFlangeChecked());
        this.planesPanel.repaint();
    }

    @Override
    public void setAvailableFeatures(Iterable<SpatialFeature> availableFeatures) {
        this.planeFeatures.setFeatures(availableFeatures);
    }

    @Override
    public void setSelectedFeatureState(ElementDefinitionState definedState) {
        this.planeFeatures.setSelectedFeatureState(definedState);
    }

    @Override
    public void setShowElbowSphere(boolean showElbowSphere) {
        this.elbowSphereVisualizer.setVisible(showElbowSphere);
    }

    @Override
    public void setEnabledAddRemovePlanes(boolean enableState) {
        this.safetyPlanes.setEnabled(enableState);
        this.planeRenderer.setEnabled(enableState);
        this.updatePlanesCounter();
    }

    @Override
    public void setEnabledRenamePlane(boolean enabled) {
        this.renamePlane.setEnabled(enabled);
    }

    @Override
    public void setEnabledSelectFeature(boolean enabled) {
        this.planeFeatures.setEnabledSelection(enabled);
    }

    @Override
    public void setEnabledSynchronizeFeature(boolean enabled) {
        this.planeFeatures.setEnabledSynchronization(enabled);
    }

    @Override
    public void setEnabledSelectSafetyMode(boolean enabled) {
        this.planeSafetyMode.setEnabled(enabled);
    }

    @Override
    public void setEnabledChangeOffset(boolean enabled) {
        this.displacement.setEnabled(enabled);
    }

    @Override
    public void setEnabledElbowRestriction(boolean enabled) {
        this.checkElbow.setEnabled(enabled);
    }

    @Override
    public void setEnabledFlangeRestriction(boolean enabled) {
        this.checkFlange.setEnabled(enabled);
    }

    @Override
    public int getNumberOfSafetyPlanesShowing() {
        return 0;
    }

    @Override
    public void updateBoundaryPlaneToleranceLabel(SafetyLimitMode safetyMode) {
    }

    @Override
    public Errorable.Status getStatus() {
        return this.formStatus.getOverallStatus();
    }

    @Override
    public void addStatusListener(Errorable.StatusListener listener) {
        this.formStatus.addStatusListener(listener);
    }

    @Override
    public void removeStatusListener(Errorable.StatusListener listener) {
        this.formStatus.removeStatusListener(listener);
    }

    private class RenamePlane
    extends EditNameView {
        public RenamePlane(WidgetFactory widgetFactory, SafetyTextResource text) {
            super(widgetFactory, new NameLengthValidationStrategy(text));
        }

        @Override
        protected void updateName(String text) {
            BoundariesPanelImpl.this.presenter.setName(text);
        }
    }

    private class SafetyPlanes
    extends MouseAdapter {
        final JList list;
        private final DefaultListModel model;
        private int selectedIndex = -1;
        private boolean enabledForEdit;

        public SafetyPlanes(WidgetFactory widgetFactory) {
            this.list = widgetFactory.createList();
            this.list.setName(SAFETY_PLANES_LIST);
            this.list.setCellRenderer(BoundariesPanelImpl.this.planeRenderer);
            this.model = new DefaultListModel();
            this.list.setModel(this.model);
            this.list.addMouseListener(this);
            this.list.setSelectionMode(0);
        }

        void setAvailablePlanes(Iterable<BoundariesPresenter.UIBoundary> planes) {
            this.model.removeAllElements();
            for (BoundariesPresenter.UIBoundary each : planes) {
                this.model.addElement(each);
            }
            this.showAddPlaneOption();
            this.selectedIndex = this.list.getSelectedIndex();
        }

        public void addSafetyPlane(BoundariesPresenter.UIBoundary safetyPlane) {
            this.model.insertElementAt(safetyPlane, this.model.getSize() - 1);
            this.list.setSelectedIndex(this.model.getSize() - 2);
            this.selectedIndex = this.model.getSize() - 2;
            this.showAddPlaneOption();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.model.isEmpty()) {
                return;
            }
            int index = this.list.locationToIndex(e.getPoint());
            Object selection = this.list.getModel().getElementAt(index);
            if (selection == BoundaryPlaneRenderer.ADD_PLANE) {
                BoundariesPanelImpl.this.presenter.addSafetyPlane();
            } else if (this.selectedIndex != index) {
                BoundariesPresenter.UIBoundary selectPlane = (BoundariesPresenter.UIBoundary)selection;
                BoundariesPanelImpl.this.presenter.selectSafetyPlane(selectPlane);
                this.selectedIndex = index;
                if (BoundariesPanelImpl.this.planeRenderer.getAction(e.getPoint()) == BoundaryPlaneRenderer.Action.SHOW) {
                    BoundariesPanelImpl.this.presenter.toggleVisible();
                }
            } else if (selection instanceof BoundariesPresenter.UIBoundary) {
                BoundariesPresenter.UIBoundary selectPlane = (BoundariesPresenter.UIBoundary)selection;
                switch (BoundariesPanelImpl.this.planeRenderer.getAction(e.getPoint())) {
                    case SHOW: {
                        BoundariesPanelImpl.this.presenter.toggleVisible();
                        break;
                    }
                    case DELETE_SAFETY_PLANE: {
                        BoundariesPanelImpl.this.presenter.removeSafetyPlane();
                        break;
                    }
                    case SELECT: {
                        this.selectedIndex = index;
                        BoundariesPanelImpl.this.presenter.selectSafetyPlane(selectPlane);
                    }
                }
            }
        }

        public void setSelectSafetyPlane(BoundariesPresenter.UIBoundary selectUIBoundary) {
            this.selectedIndex = this.model.indexOf(selectUIBoundary);
            this.list.setSelectedValue(selectUIBoundary, true);
        }

        public void setEnabled(boolean enabled) {
            this.enabledForEdit = enabled;
            this.showAddPlaneOption();
        }

        private void showAddPlaneOption() {
            if (this.enabledForEdit && BoundariesPanelImpl.this.presenter.canAddMore()) {
                if (!this.model.contains(BoundaryPlaneRenderer.ADD_PLANE)) {
                    this.model.addElement(BoundaryPlaneRenderer.ADD_PLANE);
                }
            } else {
                this.model.removeElement(BoundaryPlaneRenderer.ADD_PLANE);
            }
        }

        public boolean isSelected(BoundariesPresenter.UIBoundary plane) {
            return this.list.getSelectedValue() == plane;
        }

        private int getSafetyPlaneCount() {
            return BoundariesPanelImpl.this.presenter.getSafetyPlaneCount();
        }
    }

    public static enum SetCoordinates {
        NUMBER_FIELD;


        public <E extends Enum> String componentNameFor(E type) {
            return "Edit." + (type != null ? type.name() : UUID.randomUUID().toString()) + '.' + BoundariesPanelImpl.class.getSimpleName();
        }
    }

    private class SetDisplacement
    implements ActionListener {
        private final BoundaryInputBinder binder;
        final NumberField field;

        public SetDisplacement(BoundaryInputBinder binder) {
            this.binder = binder;
            this.field = new NumberField();
            this.field.setUnitWidth(70);
            this.field.addActionListener((ActionListener)this);
            this.field.setName(DISPLACEMENT_FIELD);
            binder.bindPlaneDisplacementSupport((InputView)this.field);
            this.setValue(0.0);
        }

        public void setPlaneBoundaryDisplacement() {
            this.binder.bindPlaneDisplacementSupport((InputView)this.field);
        }

        public void setTriggerBoundaryDisplacement() {
            this.binder.bindTriggerDisplacementSupport((InputView)this.field);
        }

        public void setValue(double value) {
            this.field.setText(String.valueOf(value));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BoundariesPanelImpl.this.presenter.setOffset(this.field.getText());
        }

        public void setEnabled(boolean enabled) {
            this.field.setEnabled(enabled);
        }
    }
}

