/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.ur.math.Length;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.resources.ViewImageResource;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.infrastructure.Boundaries3DViewPanel;
import com.ur.safety.boundaries.infrastructure.BoundariesPanel;
import com.ur.safety.boundaries.infrastructure.SafetyModeIconAndTextProvider;
import com.ur.swing.IconAndLabelProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class BoundaryPlanePanel
extends JPanel {
    public static final Icon VISIBLE = ViewImageResource.safetyBoundaryVisible();
    public static final Icon HIDDEN = ViewImageResource.safetyBoundaryHidden();
    private Color defaultBackgroundColor = this.getBackground();
    private Color highlightBackgroundColor = UIManager.getDefaults().getColor("textHighlight");
    private int index = -1;
    private BoundaryPlane boundaryPlane;
    private Boundaries3DViewPanel view3dPanel;
    private BoundariesPanel boundariesPanel;
    private IconAndLabelProvider<SafetyLimitMode> safetyModeIconProvider;
    private ViewSelectionListener viewSelectionListener = null;
    private JToggleButton enabledToggleButton;
    private JLabel nameLabel;
    private JLabel typeLabel;

    public BoundaryPlanePanel() {
        this.initComponents();
        this.enabledToggleButton.setIcon(HIDDEN);
        this.nameLabel.setForeground(Color.gray);
        this.safetyModeIconProvider = new SafetyModeIconAndTextProvider();
    }

    public BoundaryPlanePanel(BoundariesPanel boundariesPanel) {
        this();
        this.boundariesPanel = boundariesPanel;
    }

    public void assignIndex(int index) {
        this.index = index;
        this.enabledToggleButton.setName(BoundariesPanel.PLANE_VISIBILITY_TOGGLE[index]);
        this.setName(BoundariesPanel.PLANE_PANEL[index]);
    }

    public void assign3dView(Boundaries3DViewPanel view3dPanel) {
        this.view3dPanel = view3dPanel;
    }

    public int getIndex() {
        return this.index;
    }

    public BoundaryPlane getBoundaryPlane() {
        return this.boundaryPlane;
    }

    public void setBoundaryPlane(BoundaryPlane boundaryPlane) {
        this.boundaryPlane = boundaryPlane;
        this.setPlaneNameLabel(boundaryPlane.getName());
        this.updateMode(boundaryPlane.getSafetyMode());
    }

    public void copyFeature(GeomFeature feature) {
        this.boundaryPlane.copyFromGeomFeature(feature);
        if (this.boundaryPlane.isUndefined()) {
            this.typeLabel.setIcon(this.safetyModeIconProvider.getIcon((Object)SafetyLimitMode.DISABLED));
            this.nameLabel.setForeground(Color.gray);
        } else {
            this.typeLabel.setIcon(this.safetyModeIconProvider.getIcon((Object)this.boundaryPlane.getSafetyMode()));
            this.nameLabel.setForeground(Color.black);
        }
        this.updateVisualization();
    }

    public void updateVisualization() {
        if (this.view3dPanel == null) {
            return;
        }
        if ((this.isSafetyPlaneVisible() || this.isHighlighted()) && this.isBoundaryPlaneDefined()) {
            boolean highLightPlane = false;
            if (this.isHighlighted() && (this.boundariesPanel.getNumberOfSafetyPlanesShowing() > 1 || this.boundariesPanel.getNumberOfSafetyPlanesShowing() == 1 && !this.isSafetyPlaneVisible())) {
                highLightPlane = true;
            }
            this.view3dPanel.visualizePlane(this.boundaryPlane, this.getIndex(), highLightPlane);
        } else {
            this.view3dPanel.clearPlaneVisualization(this.getIndex());
        }
    }

    private boolean isBoundaryPlaneDefined() {
        return !this.boundaryPlane.isUndefined();
    }

    public double getDisplacement() {
        return this.boundaryPlane.getDisplacement().getIn(Length.Unit.SI);
    }

    public void setDisplacement(double displacement) {
        this.boundaryPlane.setDisplacement(Length.from((double)displacement, (Length.Unit)Length.Unit.SI));
        this.updateVisualization();
    }

    public String getPlaneName() {
        return this.nameLabel.getText();
    }

    public void setPlaneName(String name) {
        this.setPlaneNameLabel(name);
        this.boundaryPlane.setName(name);
    }

    public void setPlaneNameLabel(String name) {
        this.nameLabel.setText(name);
        this.nameLabel.repaint();
    }

    public SafetyLimitMode getMode() {
        return this.boundaryPlane.getSafetyMode();
    }

    public void setMode(SafetyLimitMode safetyMode) {
        this.boundaryPlane.setSafetyMode(safetyMode);
        this.updateMode(safetyMode);
    }

    public boolean isSafetyPlaneVisible() {
        return this.enabledToggleButton.isSelected();
    }

    public void setSafetyPlaneVisible(boolean enabled) {
        if (enabled) {
            this.enabledToggleButton.setIcon(VISIBLE);
        } else {
            this.enabledToggleButton.setIcon(HIDDEN);
        }
    }

    public boolean isSafetyPlaneVisualized() {
        return this.enabledToggleButton.isSelected() && this.isBoundaryPlaneDefined();
    }

    public boolean isHighlighted() {
        return this.getBackground() == this.highlightBackgroundColor;
    }

    public void setHighlighted(boolean highlight) {
        if (highlight) {
            this.setBackground(this.highlightBackgroundColor);
        } else {
            this.setBackground(this.defaultBackgroundColor);
        }
    }

    private void updateMode(SafetyLimitMode safetyMode) {
        this.typeLabel.setIcon(this.boundaryPlane.isUndefined() ? this.safetyModeIconProvider.getIcon((Object)SafetyLimitMode.DISABLED) : this.safetyModeIconProvider.getIcon((Object)safetyMode));
        if (safetyMode != SafetyLimitMode.DISABLED && this.isBoundaryPlaneDefined()) {
            this.nameLabel.setForeground(Color.black);
        }
        this.boundariesPanel.updateBoundaryPlaneToleranceLabel(safetyMode);
        this.updateVisualization();
    }

    private void enabledToggleButtonActionPerformed() {
        this.enabledToggleButton.setIcon(this.enabledToggleButton.isSelected() ? VISIBLE : HIDDEN);
        this.updateVisualization();
        this.notifyViewSelectionChanged();
    }

    private void notifyViewSelectionChanged() {
        if (this.viewSelectionListener != null) {
            this.viewSelectionListener.onViewSelectionChanged(this);
        }
    }

    public ViewSelectionListener getViewSelectionListener() {
        return this.viewSelectionListener;
    }

    public void setViewSelectionListener(ViewSelectionListener viewSelectionListener) {
        this.viewSelectionListener = viewSelectionListener;
    }

    private void initComponents() {
        this.typeLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.enabledToggleButton = new JToggleButton();
        this.setMaximumSize(new Dimension(220, 30));
        this.setMinimumSize(new Dimension(220, 30));
        this.setPreferredSize(new Dimension(220, 24));
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.typeLabel.setHorizontalAlignment(2);
        this.typeLabel.setIcon(ViewImageResource.safetyLimitModeNormal());
        this.add((Component)this.typeLabel, new AbsoluteConstraints(167, 0, -1, -1));
        this.nameLabel.setHorizontalAlignment(2);
        this.nameLabel.setText("WWWWWWWWWWWWWWW");
        this.add((Component)this.nameLabel, new AbsoluteConstraints(0, 0, 165, 25));
        this.nameLabel.getAccessibleContext().setAccessibleName("");
        this.enabledToggleButton.setFocusPainted(false);
        this.enabledToggleButton.setHorizontalAlignment(2);
        this.enabledToggleButton.setHorizontalTextPosition(2);
        this.enabledToggleButton.setIconTextGap(0);
        this.enabledToggleButton.setMargin(new Insets(0, 1, 0, 1));
        this.enabledToggleButton.setPreferredSize(new Dimension(22, 22));
        this.enabledToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoundaryPlanePanel.this.enabledToggleButtonActionPerformed();
            }
        });
        this.add((Component)this.enabledToggleButton, new AbsoluteConstraints(192, 1, 28, -1));
    }

    public static interface ViewSelectionListener {
        public void onViewSelectionChanged(BoundaryPlanePanel var1);
    }
}

