/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.ur.lang.PrimitiveUtils;
import com.ur.resources.ViewImageResource;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.boundaries.externalapi.BoundariesPresenter;
import com.ur.safety.boundaries.infrastructure.SafetyModeIconAndTextProvider;
import com.ur.swing.WidgetFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;

class BoundaryPlaneRenderer
extends JPanel
implements ListCellRenderer {
    public static final Object ADD_PLANE = new Object();
    public static final Icon BLANK_ICON = ViewImageResource.safetyLimitModeDisabled();
    private static final Border border = BorderFactory.createEmptyBorder(2, 5, 2, 5);
    private final JLabel visibility;
    private final JLabel safetyMode;
    private final JLabel name;
    private final JLabel deleteSafety;
    private final SafetyModeIconAndTextProvider provider;
    private final SafetyTextResource text;

    @Inject
    public BoundaryPlaneRenderer(WidgetFactory factory, SafetyModeIconAndTextProvider provider, SafetyTextResource text) {
        this.provider = provider;
        this.text = text;
        this.name = factory.createLabel("Dummy");
        this.safetyMode = factory.createLabel(ViewImageResource.safetyLimitModeNormalAndReduced());
        this.visibility = factory.createLabel(ViewImageResource.safetyBoundaryVisible());
        this.deleteSafety = factory.createLabel(ViewImageResource.delete());
        this.setLayout(new BoxLayout(this, 0));
        this.name.setBorder(border);
        this.safetyMode.setBorder(border);
        this.visibility.setBorder(border);
        this.deleteSafety.setBorder(border);
        this.add(this.name);
        this.add(Box.createGlue());
        this.add(this.safetyMode);
        this.add(this.visibility);
        this.add(Box.createHorizontalStrut(8));
        this.add(this.deleteSafety);
        this.add(Box.createHorizontalStrut(15));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof BoundariesPresenter.UIBoundary) {
            BoundariesPresenter.UIBoundary boundary = (BoundariesPresenter.UIBoundary)value;
            this.name.setText(boundary.getName());
            this.name.setIcon(null);
            this.safetyMode.setIcon(this.provider.getIcon(boundary.getSafetyLimitMode()));
            this.visibility.setIcon(ViewImageResource.safetyBoundaryVisible());
            this.visibility.setEnabled(boundary.isVisible());
            this.deleteSafety.setIcon(isSelected && this.isEnabled() ? ViewImageResource.delete() : BLANK_ICON);
        } else if (ADD_PLANE == value) {
            this.name.setText(this.text.addPlane());
            this.name.setIcon(ViewImageResource.gtkAdd());
            this.safetyMode.setIcon(BLANK_ICON);
            this.visibility.setIcon(BLANK_ICON);
            this.visibility.setEnabled(true);
            this.deleteSafety.setIcon(BLANK_ICON);
        }
        if (isSelected) {
            this.setBackground(UIManager.getColor("List.selectionBackground"));
        } else {
            this.setBackground(Color.white);
        }
        return this;
    }

    public Action getAction(Point point) {
        if (this.isButton(this.visibility, point)) {
            return Action.SHOW;
        }
        if (!this.isEnabled()) {
            return Action.SELECT;
        }
        if (this.isButton(this.deleteSafety, point)) {
            return Action.DELETE_SAFETY_PLANE;
        }
        return Action.SELECT;
    }

    private boolean isButton(JLabel button, Point point) {
        Point buttonPoint = new Point();
        button.getLocation(buttonPoint);
        return PrimitiveUtils.isWithinRange((double)point.getX(), (double)buttonPoint.getX(), (double)(buttonPoint.getX() + (double)button.getWidth()));
    }

    static enum Action {
        SELECT,
        DELETE_SAFETY_PLANE,
        SHOW;

    }
}

