/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.visualizer.panel.ElementsVisualizer;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.externalapi.BoundaryPlaneVisualizationStrategy;
import com.ur.safety.boundaries.infrastructure.BoundaryPlanesVisualizer;
import com.ur.util.Optional;
import javax.inject.Inject;
import javax.media.j3d.Node;

public class BoundaryPlanesProximityVisualizer
implements ElementsVisualizer {
    private final SafetySettingsLookupService safetySettingsLookupService;
    private final BoundaryPlaneVisualizationStrategy visualizationStrategy;
    private final BoundaryPlanesVisualizer visualizer;

    @Inject
    public BoundaryPlanesProximityVisualizer(SafetySettingsLookupService safetySettingsLookupService, BoundaryPlaneVisualizationStrategy visualizationStrategy, BoundaryPlanesVisualizer visualizer) {
        this.safetySettingsLookupService = safetySettingsLookupService;
        this.visualizationStrategy = visualizationStrategy;
        this.visualizer = visualizer;
    }

    public Node getElementNode() {
        return this.visualizer.getElementNode();
    }

    public void initialize() {
        Optional<SafetyBoundaries> safetyBoundaries = this.safetySettingsLookupService.getControllerComponent(SafetyBoundaries.class);
        if (safetyBoundaries.isPresent()) {
            this.visualizer.initialize((SafetyBoundaries)safetyBoundaries.get(), true, true);
        }
    }

    public void displayProximity(Pose6d tcpPose) {
        Optional<SafetyBoundaries> safetyBoundaries = this.safetySettingsLookupService.getControllerComponent(SafetyBoundaries.class);
        if (safetyBoundaries.isPresent()) {
            SafetyBoundaries boundaries = (SafetyBoundaries)safetyBoundaries.get();
            int i = 0;
            while (i < 8) {
                this.drawBoundaryPlaneProximity(boundaries.getBoundaryPlane(i), i, tcpPose);
                ++i;
            }
        }
    }

    private void drawBoundaryPlaneProximity(BoundaryPlane plane, int i, Pose6d tcpPose) {
        Pose6d tcpOffset = RobotState.getLatestRobotState().tcpOffset;
        BoundaryPlaneVisualizationStrategy.PlaneProximity proximity = this.visualizationStrategy.getLimitProximity(plane, tcpPose, tcpOffset);
        switch (proximity) {
            case LIMIT_VIOLATED: 
            case CRITICALLY_CLOSE_TO_LIMIT: {
                this.visualizer.drawPlane(plane, i, true, true);
                break;
            }
            case CLOSE_TO_LIMIT: 
            case SOMEWHAT_CLOSE_TO_LIMIT: {
                this.visualizer.drawPlane(plane, i, false, false);
                break;
            }
            case WELL_WITHIN_THE_LIMIT: {
                this.visualizer.removePlane(i);
            }
        }
    }

    public void clearVisualization() {
        this.visualizer.clearVisualization();
    }
}

