/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.image.TextureLoader;
import com.ur.polyscope.visualizer.utils.Graphics3DUtils;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.boundaries.core.BoundaryPlane;
import com.ur.safety.boundaries.core.HessianNormalFormPlane;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.util.logging.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import javax.inject.Inject;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Vector3d;

public class BoundaryPlanesVisualizer {
    private static final String SAFETY_TRIGGER_PATTERN = "safety_trigger_pattern.png";
    private static final String SAFETY_PLANE_DISABLED_PATTERN = "safety_plane_disabled_pattern.png";
    private static final String SAFETY_WARNING_PATTERN = "safety_warning_pattern.png";
    private static Texture triggerTexture;
    private static Texture disabledTexture;
    private static Texture boundaryTexture;
    private static TransparencyAttributes highlightedPlaneTransparency;
    private static TransparencyAttributes planeTransparency;
    private static ColoringAttributes disabledPlaneNormalColor;
    private static ColoringAttributes boundaryPlaneNormalColor;
    private static ColoringAttributes triggerPlaneNormalColor;
    private static ColoringAttributes boundaryPlaneWarningColor;
    private TextureAttributes textureAttribs;
    private Geometry normalArrow;
    private BoundaryPlaneGroup[] boundaryPlaneBranchGroups;
    private static boolean preInitialized;
    private boolean initBranchGroups = false;
    private static final HashMap<String, Texture> cachedTextureResources;

    static {
        preInitialized = false;
        cachedTextureResources = new HashMap();
    }

    @Inject
    public BoundaryPlanesVisualizer() {
    }

    public void preInitialize() {
        if (!preInitialized) {
            triggerTexture = this.getTextureImage(SAFETY_TRIGGER_PATTERN);
            disabledTexture = this.getTextureImage(SAFETY_PLANE_DISABLED_PATTERN);
            boundaryTexture = this.getTextureImage(SAFETY_WARNING_PATTERN);
            highlightedPlaneTransparency = new TransparencyAttributes(0, 0.65f);
            planeTransparency = new TransparencyAttributes(0, 0.85f);
            disabledPlaneNormalColor = new ColoringAttributes(new Color3f(new Color(159, 159, 159)), 0);
            boundaryPlaneNormalColor = new ColoringAttributes(new Color3f(new Color(100, 100, 100)), 0);
            triggerPlaneNormalColor = new ColoringAttributes(new Color3f(new Color(100, 161, 101)), 0);
            boundaryPlaneWarningColor = new ColoringAttributes(new Color3f(255.0f, 0.0f, 0.0f), 0);
            this.textureAttribs = new TextureAttributes();
            this.normalArrow = BoundaryPlanesVisualizer.createNormalArrow();
            BoundaryPlanesVisualizer.configureTexture(boundaryTexture);
            BoundaryPlanesVisualizer.configureTexture(disabledTexture);
            BoundaryPlanesVisualizer.configureTexture(triggerTexture);
            this.textureAttribs.setTextureMode(2);
            this.textureAttribs.setPerspectiveCorrectionMode(0);
            preInitialized = true;
        }
    }

    private Texture getTextureImage(String resource) {
        if (!cachedTextureResources.containsKey(resource)) {
            cachedTextureResources.put(resource, this.tryToTextureImage("/images/textures/" + resource));
        }
        return cachedTextureResources.get(resource);
    }

    private Texture tryToTextureImage(String resource) {
        try {
            return new TextureLoader(this.getClass().getResource(resource), (Component)new Container()).getTexture();
        }
        catch (Exception ex) {
            Log.debug((String)("Failed to load image '" + resource + "'."));
            throw new IllegalStateException("Failed to load image '" + resource + "'.", ex);
        }
    }

    private void initBranchGroups() {
        if (!this.initBranchGroups) {
            this.boundaryPlaneBranchGroups = new BoundaryPlaneGroup[8];
            int i = 0;
            while (i < this.boundaryPlaneBranchGroups.length) {
                this.boundaryPlaneBranchGroups[i] = new BoundaryPlaneGroup();
                ++i;
            }
            this.initBranchGroups = true;
        }
    }

    public Node getElementNode() {
        this.preInitialize();
        this.initBranchGroups();
        BranchGroup result = new BranchGroup();
        result.setCapability(13);
        result.setCapability(14);
        BoundaryPlaneGroup[] boundaryPlaneGroupArray = this.boundaryPlaneBranchGroups;
        int n = this.boundaryPlaneBranchGroups.length;
        int n2 = 0;
        while (n2 < n) {
            BoundaryPlaneGroup boundaryPlaneBranchGroup = boundaryPlaneGroupArray[n2];
            result.addChild((Node)boundaryPlaneBranchGroup);
            ++n2;
        }
        return result;
    }

    public void initialize(SafetyBoundaries safetyBoundaries, boolean highlightPlane, boolean markAsWarning) {
        this.initBranchGroups();
        int i = 0;
        while (i < this.boundaryPlaneBranchGroups.length) {
            this.boundaryPlaneBranchGroups[i].setPlaneAppearance(safetyBoundaries.getBoundaryPlane(i), highlightPlane, markAsWarning);
            ++i;
        }
    }

    private static void configureTexture(Texture texture) {
        texture.setBoundaryModeS(2);
        texture.setBoundaryModeT(2);
        texture.setBoundaryColor(new Color4f(0.0f, 1.0f, 0.0f, 0.0f));
        texture.setMagFilter(0);
        texture.setMinFilter(0);
        texture.setMipMapMode(1);
        texture.setMinimumLOD(0.0f);
        texture.setMaximumLOD(0.0f);
    }

    private static Geometry createNormalArrow() {
        Vector3d start = new Vector3d();
        Vector3d end = new Vector3d(0.0, 0.0, 1.0);
        end.scale(0.15);
        Vector3d axis1 = new Vector3d(1.0, 0.0, 0.0);
        Vector3d axis2 = new Vector3d(0.0, 1.0, 0.0);
        return Graphics3DUtils.getArrowFromPointToPoint((Vector3d)start, (Vector3d)end, (Vector3d)axis1, (Vector3d)axis2, (double)0.8, (double)0.02);
    }

    private static RenderingAttributes createPlaneRenderingAttributes() {
        RenderingAttributes renderingAttribs = new RenderingAttributes();
        renderingAttribs.setCapability(6);
        renderingAttribs.setVisible(false);
        return renderingAttribs;
    }

    private boolean isPlaneIndexValid(int plane) {
        return plane >= 0 || plane < 8;
    }

    public void clearVisualization() {
        BoundaryPlaneGroup[] boundaryPlaneGroupArray = this.boundaryPlaneBranchGroups;
        int n = this.boundaryPlaneBranchGroups.length;
        int n2 = 0;
        while (n2 < n) {
            BoundaryPlaneGroup planeBranchGroup = boundaryPlaneGroupArray[n2];
            planeBranchGroup.removePlaneVisualization();
            ++n2;
        }
    }

    public void clearPlaneVisualization(int plane) {
        if (this.initBranchGroups && this.isPlaneIndexValid(plane)) {
            this.boundaryPlaneBranchGroups[plane].removePlaneVisualization();
        }
    }

    private TransformGroup createTransformGroup() {
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(18);
        return transformGroup;
    }

    public void drawPlane(BoundaryPlane boundaryPlane, int plane, boolean highlightPlane, boolean markAsWarning) {
        if (this.isPlaneIndexValid(plane) && boundaryPlane != null && !boundaryPlane.isUndefined()) {
            this.drawDefinedPlane(boundaryPlane, this.boundaryPlaneBranchGroups[plane], highlightPlane, markAsWarning);
        }
    }

    private void drawDefinedPlane(BoundaryPlane boundaryPlane, BoundaryPlaneGroup boundaryPlaneGroup, boolean highlightPlane, boolean markAsWarning) {
        boolean doHighlightPlane = highlightPlane && this.isMoreThanThisPlaneGroupVisible(boundaryPlaneGroup);
        boundaryPlaneGroup.displayPlane(boundaryPlane, doHighlightPlane, markAsWarning);
    }

    private boolean isMoreThanThisPlaneGroupVisible(BoundaryPlaneGroup thisBoundaryPlaneGroup) {
        int numberOfVisualPlanes = this.getNumberOfVisualBoundaryPlaneGroups();
        return numberOfVisualPlanes > 1 || numberOfVisualPlanes == 1 && !thisBoundaryPlaneGroup.isVisible;
    }

    private int getNumberOfVisualBoundaryPlaneGroups() {
        int count = 0;
        BoundaryPlaneGroup[] boundaryPlaneGroupArray = this.boundaryPlaneBranchGroups;
        int n = this.boundaryPlaneBranchGroups.length;
        int n2 = 0;
        while (n2 < n) {
            BoundaryPlaneGroup each = boundaryPlaneGroupArray[n2];
            if (each.isVisible) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public void removePlane(int i) {
        this.boundaryPlaneBranchGroups[i].removePlaneVisualization();
    }

    public boolean isDisplayed(int planeId) {
        if (this.isPlaneIndexValid(planeId)) {
            return this.boundaryPlaneBranchGroups[planeId].isVisible();
        }
        return false;
    }

    private void addTexture(Texture texture, Appearance appearance) {
        appearance.setTexture(texture);
        appearance.setTextureAttributes(this.textureAttribs);
    }

    static /* synthetic */ RenderingAttributes access$0() {
        return BoundaryPlanesVisualizer.createPlaneRenderingAttributes();
    }

    static /* synthetic */ Texture access$1() {
        return disabledTexture;
    }

    private class BoundaryPlaneGroup
    extends BranchGroup {
        private final RenderingAttributes planeRenderingAttribs = BoundaryPlanesVisualizer.access$0();
        private final Appearance boundaryPlaneAppearance = this.getAppearance(PlaneType.BOUNDARY);
        private final Appearance disabledBoundaryPlaneAppearance = this.getAppearanceWithTexture(BoundaryPlanesVisualizer.access$1());
        private final Appearance triggerPlaneApperance = this.getAppearance(PlaneType.TRIGGER);
        private final TransformGroup planeTransformGroup;
        private final Primitive planeGeomtricPrimitive = this.getPlaneGeomtricPrimitive();
        private final Shape3D normalGeometry = this.getNormalGeometry();
        private HessianNormalFormPlane hessianNormalPlane = new HessianNormalFormPlane();
        private boolean isHighlighted = false;
        private boolean isMarkedAsWarning = false;
        private boolean isDisplayingEnabledPlane = false;
        private boolean isVisible = false;
        private PlaneType planeTypeDisplayed = PlaneType.BOUNDARY;

        public BoundaryPlaneGroup() {
            this.planeTransformGroup = BoundaryPlanesVisualizer.this.createTransformGroup();
            this.addChild((Node)this.planeTransformGroup);
            this.planeTransformGroup.addChild((Node)this.planeGeomtricPrimitive);
            this.planeTransformGroup.addChild((Node)this.normalGeometry);
        }

        private boolean isVisible() {
            return this.planeRenderingAttribs.getVisible();
        }

        private void setPlaneVisualizationVisibility(boolean visible) {
            if (visible != this.isVisible) {
                this.isVisible = visible;
                this.planeRenderingAttribs.setVisible(visible);
            }
        }

        public void displayPlane(BoundaryPlane plane, boolean highlightPlane, boolean markAsWarning) {
            if (!this.hessianNormalPlane.equals(plane.getPlaneParameters())) {
                this.planeTransformGroup.setTransform(plane.getTransform());
                this.hessianNormalPlane = plane.getPlaneParameters();
            }
            this.setPlaneAppearance(plane, highlightPlane, markAsWarning);
            this.setPlaneVisualizationVisibility(true);
        }

        private Shape3D getNormalGeometry() {
            Appearance planeNormalAppearance = new Appearance();
            planeNormalAppearance.setColoringAttributes(disabledPlaneNormalColor);
            planeNormalAppearance.setLineAttributes(new LineAttributes(3.0f, 0, false));
            Shape3D planeNormalGeometry = new Shape3D(BoundaryPlanesVisualizer.this.normalArrow, planeNormalAppearance);
            planeNormalGeometry.getAppearance().setCapability(9);
            planeNormalGeometry.getAppearance().setRenderingAttributes(this.planeRenderingAttribs);
            return planeNormalGeometry;
        }

        private Primitive getPlaneGeomtricPrimitive() {
            return new Box(1.2f, 1.2f, 0.005f, 66, this.disabledBoundaryPlaneAppearance);
        }

        private Appearance getAppearanceWithTexture(Texture texture) {
            Appearance appearance = new Appearance();
            LineAttributes lineAttributes = new LineAttributes();
            lineAttributes.setLineWidth(2.0f);
            appearance.setLineAttributes(lineAttributes);
            BoundaryPlanesVisualizer.this.addTexture(texture, appearance);
            appearance.setCapability(9);
            appearance.setCapability(11);
            appearance.setColoringAttributes(boundaryPlaneNormalColor);
            appearance.setRenderingAttributes(this.planeRenderingAttribs);
            appearance.setTransparencyAttributes(planeTransparency);
            return appearance;
        }

        private Appearance getAppearance(PlaneType planeType) {
            switch (planeType) {
                case BOUNDARY: {
                    return this.getAppearanceWithTexture(boundaryTexture);
                }
                case TRIGGER: {
                    return this.getAppearanceWithTexture(triggerTexture);
                }
            }
            return this.getAppearanceWithTexture(boundaryTexture);
        }

        private Appearance gePlaneApperance(BoundaryPlane plane) {
            if (plane.getSafetyMode() == SafetyLimitMode.DISABLED) {
                return this.disabledBoundaryPlaneAppearance;
            }
            switch (this.getPlaneType(plane)) {
                case BOUNDARY: {
                    return this.boundaryPlaneAppearance;
                }
                case TRIGGER: {
                    return this.triggerPlaneApperance;
                }
            }
            return this.disabledBoundaryPlaneAppearance;
        }

        private void setPlaneAppearance(BoundaryPlane plane, boolean highlightPlane, boolean markAsWarning) {
            if (this.getPlaneType(plane) != this.planeTypeDisplayed || this.isDisplayingEnabledPlane != plane.isEnabled()) {
                this.planeGeomtricPrimitive.setAppearance(this.gePlaneApperance(plane));
                this.setPlaneNormalColor(plane);
                this.planeTypeDisplayed = this.getPlaneType(plane);
                this.isDisplayingEnabledPlane = plane.isEnabled();
                this.updatePlaneTransparency(highlightPlane);
            }
            if (this.isMarkedAsWarning != markAsWarning) {
                if (markAsWarning) {
                    this.planeGeomtricPrimitive.getAppearance().setColoringAttributes(boundaryPlaneWarningColor);
                } else {
                    this.planeGeomtricPrimitive.getAppearance().setColoringAttributes(null);
                }
                this.isMarkedAsWarning = markAsWarning;
            }
            if (this.isHighlighted != highlightPlane) {
                this.updatePlaneTransparency(highlightPlane);
            }
        }

        private void updatePlaneTransparency(boolean highlightPlane) {
            if (highlightPlane) {
                this.planeGeomtricPrimitive.getAppearance().setTransparencyAttributes(highlightedPlaneTransparency);
            } else {
                this.planeGeomtricPrimitive.getAppearance().setTransparencyAttributes(planeTransparency);
            }
            this.isHighlighted = highlightPlane;
        }

        private ColoringAttributes getPlaneNormalColor(BoundaryPlane plane) {
            if (plane.getSafetyMode() == SafetyLimitMode.DISABLED) {
                return disabledPlaneNormalColor;
            }
            switch (this.getPlaneType(plane)) {
                case BOUNDARY: {
                    return boundaryPlaneNormalColor;
                }
                case TRIGGER: {
                    return triggerPlaneNormalColor;
                }
            }
            return disabledPlaneNormalColor;
        }

        private void setPlaneNormalColor(BoundaryPlane plane) {
            this.normalGeometry.getAppearance().setColoringAttributes(this.getPlaneNormalColor(plane));
        }

        public void removePlaneVisualization() {
            this.setPlaneVisualizationVisibility(false);
        }

        public PlaneType getPlaneType(BoundaryPlane plane) {
            if (plane.isTrigger()) {
                return PlaneType.TRIGGER;
            }
            return PlaneType.BOUNDARY;
        }
    }

    private static enum PlaneType {
        BOUNDARY,
        TRIGGER;

    }
}

