/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.resources.ViewImageResource;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.boundaries.infrastructure.Boundaries3DViewPanel;
import com.ur.safety.boundaries.infrastructure.SafetyModeIconAndTextProvider;
import com.ur.swing.IconAndLabelProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class BoundaryToolOrientationLimitPanel
extends JPanel {
    private static final Color DEFAULT_BACKGROUND_COLOR = UIManager.getDefaults().getColor("Panel.background");
    private static final Color HIGHLIGHT_BACKGROUND_COLOR = UIManager.getDefaults().getColor("textHighlight");
    private static final Icon VISIBLE = ViewImageResource.safetyBoundaryVisible();
    private static final Icon HIDDEN = ViewImageResource.safetyBoundaryHidden();
    private final SafetyTextResource textResource;
    private final IconAndLabelProvider<SafetyLimitMode> safetyModeIconProvider;
    private ToolOrientationLimit tcpOrientationLimit;
    private Boundaries3DViewPanel view3dPanel;
    private JToggleButton enabledToggleButton;
    private JLabel nameLabel;
    private JLabel typeLabel;

    public BoundaryToolOrientationLimitPanel(SafetyTextResource textResource) {
        this.textResource = textResource;
        this.initComponents();
        this.enabledToggleButton.setIcon(HIDDEN);
        this.enabledToggleButton.setName("toolVisibilityToggle.BoundariesPanel");
        this.nameLabel.setForeground(Color.gray);
        this.safetyModeIconProvider = new SafetyModeIconAndTextProvider();
    }

    public void assign3dView(Boundaries3DViewPanel view3dPanel) {
        this.view3dPanel = view3dPanel;
    }

    public void copyFeature(GeomFeature feature) {
        this.tcpOrientationLimit.copyFromGeomFeature(feature);
        if (this.tcpOrientationLimit.isUndefined()) {
            this.typeLabel.setIcon(this.safetyModeIconProvider.getIcon((Object)SafetyLimitMode.DISABLED));
            this.nameLabel.setForeground(Color.gray);
        } else {
            this.typeLabel.setIcon(this.safetyModeIconProvider.getIcon((Object)this.tcpOrientationLimit.getSafetyMode()));
            this.nameLabel.setForeground(Color.black);
        }
        this.updateVisualization();
    }

    public void updateVisualization() {
        if (this.view3dPanel != null) {
            if ((this.isToolLimitVisible() || this.isHighlighted()) && this.isOrientationLimitDefined()) {
                this.view3dPanel.visualizeToolOrientationLimit(this.getToolOrientationLimit());
            } else {
                this.view3dPanel.clearToolOrientationLimitVisualization();
            }
        }
    }

    public UUID getFeatureId() {
        return this.tcpOrientationLimit.getSourceFeatureId();
    }

    public SafetyLimitMode getMode() {
        return this.tcpOrientationLimit.getSafetyMode();
    }

    public void setMode(SafetyLimitMode safetyMode) {
        this.tcpOrientationLimit.setSafetyMode(safetyMode);
        this.updateMode(safetyMode);
    }

    public ToolOrientationLimit getToolOrientationLimit() {
        return this.tcpOrientationLimit;
    }

    public void setToolOrientationLimit(ToolOrientationLimit tcpOrientationLimits) {
        this.tcpOrientationLimit = tcpOrientationLimits;
        this.updateMode(tcpOrientationLimits.getSafetyMode());
    }

    public double getToolOrientationDeviation() {
        return Math.min(ToolOrientationLimit.TOOL_ORIENTATION_DEVIATION_MAXIMUM, this.tcpOrientationLimit.getMaximumTcpOrientationDeviation());
    }

    public void setToolOrientationDeviation(double deviation) {
        this.tcpOrientationLimit.setMaximumTcpOrientationDeviation(deviation);
        this.updateVisualization();
    }

    public void setToolOrientationLimitVisible(boolean enabled) {
        if (enabled) {
            this.enabledToggleButton.setIcon(VISIBLE);
        } else {
            this.enabledToggleButton.setIcon(HIDDEN);
        }
    }

    public boolean isHighlighted() {
        return this.getBackground() == HIGHLIGHT_BACKGROUND_COLOR;
    }

    public void highlight(boolean highlight) {
        if (highlight) {
            this.setBackground(HIGHLIGHT_BACKGROUND_COLOR);
        } else {
            this.setBackground(DEFAULT_BACKGROUND_COLOR);
        }
    }

    public boolean isToolLimitVisible() {
        return this.enabledToggleButton.isSelected();
    }

    private void updateMode(SafetyLimitMode safetyMode) {
        this.typeLabel.setIcon(this.tcpOrientationLimit.isUndefined() ? this.safetyModeIconProvider.getIcon((Object)SafetyLimitMode.DISABLED) : this.safetyModeIconProvider.getIcon((Object)safetyMode));
        if (safetyMode != SafetyLimitMode.DISABLED && this.isOrientationLimitDefined()) {
            this.nameLabel.setForeground(Color.black);
        }
        this.updateVisualization();
    }

    private boolean isOrientationLimitDefined() {
        return !this.tcpOrientationLimit.isUndefined();
    }

    private void initComponents() {
        this.typeLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.enabledToggleButton = new JToggleButton();
        this.setMaximumSize(new Dimension(220, 30));
        this.setMinimumSize(new Dimension(220, 30));
        this.setPreferredSize(new Dimension(220, 24));
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.typeLabel.setHorizontalAlignment(2);
        this.typeLabel.setIcon(ViewImageResource.safetyLimitModeNormal());
        this.add((Component)this.typeLabel, new AbsoluteConstraints(167, 0, -1, -1));
        this.nameLabel.setHorizontalAlignment(2);
        this.nameLabel.setText(this.textResource.safetyToolBoundary());
        this.add((Component)this.nameLabel, new AbsoluteConstraints(0, 0, 165, 25));
        this.nameLabel.getAccessibleContext().setAccessibleName("");
        this.enabledToggleButton.setFocusPainted(false);
        this.enabledToggleButton.setHorizontalAlignment(4);
        this.enabledToggleButton.setHorizontalTextPosition(4);
        this.enabledToggleButton.setMargin(new Insets(0, 1, 0, 1));
        this.enabledToggleButton.setPreferredSize(new Dimension(22, 22));
        this.enabledToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BoundaryToolOrientationLimitPanel.this.enabledToggleButtonActionPerformed();
            }
        });
        this.add((Component)this.enabledToggleButton, new AbsoluteConstraints(192, 1, 28, -1));
    }

    private void enabledToggleButtonActionPerformed() {
        if (this.enabledToggleButton.getIcon() == HIDDEN) {
            this.enabledToggleButton.setIcon(VISIBLE);
        } else {
            this.enabledToggleButton.setIcon(HIDDEN);
        }
        this.updateVisualization();
    }
}

