/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.safety.position.ElbowPosition;
import com.ur.polyscope.visualizer.element.VisualizerElement;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.externalapi.BoundaryPlaneProximitySource;
import com.ur.safety.boundaries.externalapi.BoundaryPlaneVisualizationStrategy;
import com.ur.safety.boundaries.infrastructure.ElbowSphereVisualizer;
import com.ur.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.media.j3d.Node;

public class ElbowSphereProximityVisualizer
implements VisualizerElement {
    private final SafetySettingsLookupService safetyLookup;
    private final BoundaryPlaneVisualizationStrategy visualizationStrategy;
    private final ElbowSphereVisualizer visualizer;

    @Inject
    public ElbowSphereProximityVisualizer(SafetySettingsLookupService safetyLookup, BoundaryPlaneVisualizationStrategy visualizationStrategy, Provider<ElbowPosition> elbowPositionProvider) {
        this.safetyLookup = safetyLookup;
        this.visualizationStrategy = visualizationStrategy;
        this.visualizer = new ElbowSphereVisualizer(elbowPositionProvider);
    }

    public VisualizerElementType getElementType() {
        return VisualizerElementType.SAFETY_SPHERES;
    }

    public Node getElementNode() {
        return this.visualizer.getElementNode();
    }

    public void update() {
        BoundaryPlaneVisualizationStrategy.PlaneProximity proximity = BoundaryPlaneVisualizationStrategy.PlaneProximity.WELL_WITHIN_THE_LIMIT;
        Optional<SafetyBoundaries> safetyBoundaries = this.safetyLookup.getControllerComponent(SafetyBoundaries.class);
        if (safetyBoundaries.isPresent()) {
            Pose6d tcpOffset = RobotState.getLatestRobotState().tcpOffset;
            Pose6d tcpPose = RobotState.getLatestRobotState().tool;
            proximity = this.visualizationStrategy.getLimitProximity((SafetyBoundaries)safetyBoundaries.get(), BoundaryPlaneProximitySource.ELBOW, tcpPose, tcpOffset);
        }
        switch (proximity) {
            case LIMIT_VIOLATED: 
            case CRITICALLY_CLOSE_TO_LIMIT: 
            case CLOSE_TO_LIMIT: 
            case SOMEWHAT_CLOSE_TO_LIMIT: {
                this.visualizer.update();
                this.visualizer.setVisible(true);
                break;
            }
            default: {
                this.visualizer.setVisible(false);
            }
        }
    }
}

