/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.sun.j3d.utils.geometry.Sphere;
import com.ur.math.Length;
import com.ur.polyscope.safety.position.ElbowPosition;
import com.ur.polyscope.visualizer.element.VisualizerElement;
import com.ur.polyscope.visualizer.element.VisualizerElementType;
import com.ur.safety.workpiece.infrastructure.ToolSphereVisualizer;
import javax.inject.Provider;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ElbowSphereVisualizer
implements VisualizerElement {
    private final Provider<ElbowPosition> elbowPositionProvider;
    private Appearance elbowSphereApearance;
    private RenderingAttributes elbowSphereRenderingAttributes;
    private BranchGroup subBranchGroup;
    private final Vector3d cachedElbowCenterPosition = new Vector3d();
    private boolean visible = false;
    private TransformGroup individualSphereTransformGroup;

    public ElbowSphereVisualizer(Provider<ElbowPosition> elbowPositionProvider) {
        this.elbowPositionProvider = elbowPositionProvider;
    }

    public VisualizerElementType getElementType() {
        return VisualizerElementType.SAFETY_SPHERES;
    }

    public Node getElementNode() {
        this.elbowSphereApearance = ToolSphereVisualizer.getRegularToolSphereAppearance();
        this.elbowSphereRenderingAttributes = new RenderingAttributes();
        this.elbowSphereRenderingAttributes.setCapability(6);
        this.elbowSphereRenderingAttributes.setVisible(this.visible);
        this.elbowSphereApearance.setRenderingAttributes(this.elbowSphereRenderingAttributes);
        this.subBranchGroup = new BranchGroup();
        this.subBranchGroup.setCapability(13);
        this.subBranchGroup.setCapability(14);
        this.individualSphereTransformGroup = new TransformGroup();
        this.individualSphereTransformGroup.setCapability(14);
        this.individualSphereTransformGroup.setCapability(13);
        this.individualSphereTransformGroup.setCapability(18);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild((Node)this.individualSphereTransformGroup);
        return branchGroup;
    }

    public void update() {
        ElbowPosition elbowPosition = (ElbowPosition)this.elbowPositionProvider.get();
        Vector3d elbowCenter = elbowPosition.getPosition().toVector3d();
        if (!this.subBranchGroup.getAllChildren().hasMoreElements()) {
            this.subBranchGroup.addChild((Node)new Sphere((float)Math.max(0.01, elbowPosition.getRadius().getIn(Length.Unit.SI)), this.elbowSphereApearance));
            this.individualSphereTransformGroup.addChild((Node)this.subBranchGroup);
        }
        this.elbowSphereRenderingAttributes.setVisible(this.visible);
        if (this.cachedElbowCenterPosition.epsilonEquals((Tuple3d)elbowCenter, 0.001)) {
            return;
        }
        this.cachedElbowCenterPosition.set((Tuple3d)elbowCenter);
        Transform3D individualSphereTransformation = new Transform3D();
        individualSphereTransformation.setTranslation(elbowCenter);
        this.individualSphereTransformGroup.setTransform(individualSphereTransformation);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.elbowSphereRenderingAttributes != null && this.elbowSphereRenderingAttributes.getVisible() != visible) {
            this.update();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public static class Update
    implements Runnable {
        private final ElbowSphereVisualizer elbowSphereVisualizer;

        public Update(ElbowSphereVisualizer elbowSphereVisualizer) {
            this.elbowSphereVisualizer = elbowSphereVisualizer;
        }

        @Override
        public void run() {
            this.elbowSphereVisualizer.update();
        }
    }
}

