/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.ur.lang.resources.LocaleProvider;
import com.ur.resources.ViewImageResource;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.Settings;
import com.ur.safety.impl.SafetyTextResourceImpl;
import com.ur.swing.IconAndLabelProvider;
import java.util.Locale;
import javax.swing.Icon;

public class SafetyModeIconAndTextProvider
implements IconAndLabelProvider<SafetyLimitMode> {
    public Icon getIcon(SafetyLimitMode value) {
        switch (value) {
            case DISABLED: {
                return ViewImageResource.safetyLimitModeDisabled();
            }
            case NORMAL: {
                return ViewImageResource.safetyLimitModeNormal();
            }
            case REDUCED: {
                return ViewImageResource.safetyLimitModeReduced();
            }
            case BOTH: {
                return ViewImageResource.safetyLimitModeNormalAndReduced();
            }
            case TRIGGER: {
                return ViewImageResource.safetyLimitModeTriggerReduced();
            }
        }
        throw new IllegalStateException("The type " + ((Object)((Object)value)).getClass().getSimpleName() + " does not have an ICON supporting it!");
    }

    public String getText(SafetyLimitMode value) {
        SafetyTextResourceImpl textResource = new SafetyTextResourceImpl(new LocaleProvider(){

            public Locale getLocale() {
                return Settings.getLanguage().getLocale();
            }
        });
        return textResource.safetyLimitMode(value);
    }
}

