/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.visualizer.panel.ElementsVisualizer;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.boundaries.externalapi.ToolOrientationVisualizationStrategy;
import com.ur.safety.boundaries.infrastructure.ToolDirectionVisualizer;
import com.ur.util.Optional;
import javax.inject.Inject;
import javax.media.j3d.Node;

public class ToolDirectionProximityVisualizer
implements ElementsVisualizer {
    private final SafetySettingsLookupService safetyLookup;
    private final ToolOrientationVisualizationStrategy toolOrientationVisualizationStrategy;
    private final ToolDirectionVisualizer visualizer;

    @Inject
    private ToolDirectionProximityVisualizer(SafetySettingsLookupService safetyLookup, ToolOrientationVisualizationStrategy toolOrientationVisualizationStrategy, ToolDirectionVisualizer visualizer) {
        this.safetyLookup = safetyLookup;
        this.toolOrientationVisualizationStrategy = toolOrientationVisualizationStrategy;
        this.visualizer = visualizer;
    }

    public Node getElementNode() {
        return this.visualizer.getElementNode();
    }

    public void initialize() {
    }

    public void clearVisualization() {
        this.visualizer.clearVisualization();
    }

    public void displayProximity(Pose6d tcpPose) {
        Pose6d tcpOffset = RobotState.getLatestRobotState().tcpOffset;
        ToolOrientationVisualizationStrategy.OrientationLimitProximity proximity = ToolOrientationVisualizationStrategy.OrientationLimitProximity.WELL_WITHIN_THE_LIMIT;
        Optional<SafetySetup> controllerSafetySetup = this.safetyLookup.getControllerSafetySetup();
        if (controllerSafetySetup.isPresent()) {
            proximity = this.toolOrientationVisualizationStrategy.getLimitProximity((SafetySetup)controllerSafetySetup.get(), tcpPose, tcpOffset);
        }
        switch (proximity) {
            case LIMIT_VIOLATED: 
            case CRITICALLY_CLOSE_TO_LIMIT: 
            case CLOSE_TO_LIMIT: 
            case SOMEWHAT_CLOSE_TO_LIMIT: {
                this.visualizer.display(this.toolOrientationVisualizationStrategy.getToolOrientationLimitPose((SafetySetup)controllerSafetySetup.get(), tcpPose, tcpOffset));
                break;
            }
            default: {
                this.clearVisualization();
            }
        }
    }
}

