/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.polyscope.visualizer.utils.Graphics3DUtils;
import com.ur.safety.boundaries.infrastructure.ToolOrientationBoundaryVisualizer;
import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

public class ToolDirectionVisualizer {
    private static final double TOOL_ORIENTATION_VECTOR_LENGTH = 0.08;
    private final ArrowSettings arrowSettings = new ArrowSettings(3.0f, new Color(0.45f, 0.3f, 0.15f));
    private boolean preInitialized = false;
    private RenderingAttributes renderAttribsToolOrientation;
    private TransformGroup currentToolOrientationTransformGroup;

    public void preInitialize() {
        if (!this.preInitialized) {
            this.renderAttribsToolOrientation = ToolOrientationBoundaryVisualizer.createRenderingAttributes();
            this.preInitialized = true;
        }
    }

    public Node getElementNode() {
        this.preInitialize();
        BranchGroup currentToolOrientationBranchGroup = ToolOrientationBoundaryVisualizer.createBranchGroup();
        this.currentToolOrientationTransformGroup = ToolOrientationBoundaryVisualizer.createTransformGroup();
        this.currentToolOrientationTransformGroup.addChild((Node)this.createToolOrientationVectorGeometry());
        currentToolOrientationBranchGroup.addChild((Node)this.currentToolOrientationTransformGroup);
        BranchGroup result = new BranchGroup();
        result.setCapability(13);
        result.setCapability(14);
        result.addChild((Node)currentToolOrientationBranchGroup);
        return result;
    }

    public void clearVisualization() {
        this.setToolOrientationVisualizationVisibility(false);
    }

    public void display(Pose6d currentToolBasePose) {
        this.setToolOrientationVisualizationVisibility(true);
        this.updateCurrentToolOrientationGeomtry(currentToolBasePose);
    }

    private Shape3D createToolOrientationVectorGeometry() {
        Vector3d origo = new Vector3d(0.0, 0.0, 0.0);
        Vector3d xAxis = new Vector3d(0.1, 0.0, 0.0);
        Vector3d yAxis = new Vector3d(0.0, 0.1, 0.0);
        Vector3d pointEndOfToolOrientation = new Vector3d(0.0, 0.0, 1.0);
        pointEndOfToolOrientation.scale(0.08);
        LineArray arrowArray = Graphics3DUtils.getArrowFromPointToPoint((Vector3d)origo, (Vector3d)pointEndOfToolOrientation, (Vector3d)xAxis, (Vector3d)yAxis, (double)0.85, (double)0.005);
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(new Color3f(this.arrowSettings.color), 0));
        appearance.setLineAttributes(new LineAttributes(this.arrowSettings.thickness, 0, false));
        appearance.setRenderingAttributes(this.renderAttribsToolOrientation);
        return new Shape3D((Geometry)arrowArray, appearance);
    }

    private void updateCurrentToolOrientationGeomtry(Pose6d toolPose) {
        this.currentToolOrientationTransformGroup.setTransform(URMath.getTransform((Pose6d)toolPose));
    }

    private void setToolOrientationVisualizationVisibility(boolean visible) {
        if (visible != this.renderAttribsToolOrientation.getVisible()) {
            this.renderAttribsToolOrientation.setVisible(visible);
        }
    }

    private static class ArrowSettings {
        public final float thickness;
        public final Color color;

        public ArrowSettings(float thickness, Color color) {
            this.thickness = thickness;
            this.color = color;
        }
    }
}

