/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.visualizer.panel.ElementsVisualizer;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.boundaries.externalapi.ToolOrientationVisualizationStrategy;
import com.ur.safety.boundaries.infrastructure.ToolOrientationBoundaryVisualizer;
import com.ur.util.Optional;
import javax.inject.Inject;
import javax.media.j3d.Node;

public class ToolOrientationBoundaryProximityVisualizer
implements ElementsVisualizer {
    private final SafetySettingsLookupService safetySettingsProvider;
    private final ToolOrientationVisualizationStrategy proximityStrategy;
    private final ToolOrientationBoundaryVisualizer visualizer;

    @Inject
    public ToolOrientationBoundaryProximityVisualizer(SafetySettingsLookupService safetySettingsProvider, ToolOrientationVisualizationStrategy proximityStrategy, ToolOrientationBoundaryVisualizer visualizer) {
        this.safetySettingsProvider = safetySettingsProvider;
        this.proximityStrategy = proximityStrategy;
        this.visualizer = visualizer;
    }

    public Node getElementNode() {
        return this.visualizer.getElementNode();
    }

    public void initialize() {
        Optional<SafetyBoundaries> safetyBoundaries = this.safetySettingsProvider.getControllerComponent(SafetyBoundaries.class);
        if (safetyBoundaries.isPresent()) {
            ToolOrientationLimit toolOrientationLimit = ((SafetyBoundaries)safetyBoundaries.get()).getToolOrientationLimit();
            this.visualizer.updateLimitCone(toolOrientationLimit);
        }
    }

    public void clearVisualization() {
        this.visualizer.clearVisualization();
    }

    public void displayProximity(Pose6d tcpPose) {
        Pose6d tcpOffset = RobotState.getLatestRobotState().tcpOffset;
        ToolOrientationVisualizationStrategy.OrientationLimitProximity proximity = ToolOrientationVisualizationStrategy.OrientationLimitProximity.WELL_WITHIN_THE_LIMIT;
        Optional<SafetySetup> safetySetup = this.safetySettingsProvider.getControllerSafetySetup();
        if (safetySetup.isPresent()) {
            proximity = this.proximityStrategy.getLimitProximity((SafetySetup)safetySetup.get(), tcpPose, tcpOffset);
        }
        switch (proximity) {
            case LIMIT_VIOLATED: 
            case CRITICALLY_CLOSE_TO_LIMIT: {
                this.showToolOrientationLimit((SafetySetup)safetySetup.get(), tcpPose, tcpOffset, true);
                break;
            }
            case CLOSE_TO_LIMIT: 
            case SOMEWHAT_CLOSE_TO_LIMIT: {
                this.showToolOrientationLimit((SafetySetup)safetySetup.get(), tcpPose, tcpOffset, false);
                break;
            }
            default: {
                this.visualizer.clearVisualization();
            }
        }
    }

    private void showToolOrientationLimit(SafetySetup safetySetup, Pose6d tcpPose, Pose6d tcpOffset, boolean markAsWarning) {
        ToolOrientationLimit toolOrientationLimit = ((SafetyBoundaries)safetySetup.getComponent(SafetyBoundaries.class)).getToolOrientationLimit();
        Pose6d toolPose = this.proximityStrategy.getToolOrientationLimitPose(safetySetup, tcpPose, tcpOffset);
        this.visualizer.showToolOrientationLimit(toolOrientationLimit, toolPose.getPos(), markAsWarning);
    }
}

