/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.boundaries.infrastructure;

import com.ur.polyscope.visualizer.utils.MaterialDB;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import javax.inject.Inject;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.freehep.j3d.SphereSegment;

public class ToolOrientationBoundaryVisualizer {
    private static final Object FREEHEP_JAVA3D_LIBRARY_LOCK = new Object();
    private static final double VISUALIZATION_HEIGHT = 0.11;
    private boolean isMarkedAsWarning = false;
    private boolean isDisplayingEnabledBoundary = false;
    private RenderingAttributes RENDER_ATTRIBS_LIMIT;
    private Appearance disabledOrientationDeviationLimitAppearance;
    private Appearance orientationDeviationLimitAppearance;
    private Appearance warningOrientationDeviationLimitAppearance;
    private TransformGroup toolOrientationDeviationLimitTransformGroup;
    private BranchGroup toolOrientationDeviationGeometryBranchGroup;
    private Shape3D toolOrientationDeviationGeometry;
    private double toolDeviation = 0.0;
    private Vector3d limitTcpOrientationVector = new Vector3d();
    private boolean preInitialized = false;

    @Inject
    public ToolOrientationBoundaryVisualizer() {
    }

    public void preInitialize() {
        if (!this.preInitialized) {
            TransparencyAttributes limitTransparency = new TransparencyAttributes(0, 0.5f);
            this.RENDER_ATTRIBS_LIMIT = ToolOrientationBoundaryVisualizer.createRenderingAttributes();
            this.disabledOrientationDeviationLimitAppearance = ToolOrientationBoundaryVisualizer.getOrientationDeviationLimitAppearance(AppearanceType.DISABLED, limitTransparency, this.RENDER_ATTRIBS_LIMIT);
            this.orientationDeviationLimitAppearance = ToolOrientationBoundaryVisualizer.getOrientationDeviationLimitAppearance(AppearanceType.ENABLED, limitTransparency, this.RENDER_ATTRIBS_LIMIT);
            this.warningOrientationDeviationLimitAppearance = ToolOrientationBoundaryVisualizer.getOrientationDeviationLimitAppearance(AppearanceType.WARNING, limitTransparency, this.RENDER_ATTRIBS_LIMIT);
            this.preInitialized = true;
        }
    }

    public Node getElementNode() {
        this.preInitialize();
        BranchGroup toolOrientationDeviationLimitBranchGroup = ToolOrientationBoundaryVisualizer.createBranchGroup();
        this.toolOrientationDeviationLimitTransformGroup = ToolOrientationBoundaryVisualizer.createTransformGroup();
        toolOrientationDeviationLimitBranchGroup.addChild((Node)this.toolOrientationDeviationLimitTransformGroup);
        BranchGroup result = new BranchGroup();
        result.setCapability(13);
        result.setCapability(14);
        result.addChild((Node)toolOrientationDeviationLimitBranchGroup);
        return result;
    }

    public boolean isDisplayingLimit() {
        return this.RENDER_ATTRIBS_LIMIT.getVisible();
    }

    public void showToolOrientationLimit(ToolOrientationLimit toolOrientationLimit, Vector3d toolPosition, boolean markAsWarning) {
        if (!this.limitTcpOrientationVector.equals((Tuple3d)toolOrientationLimit.getTCPOrientationVector().toVector3d())) {
            Transform3D toolOrientationBoundaryTransform = new Transform3D(toolOrientationLimit.getTransform());
            toolOrientationBoundaryTransform.setTranslation(toolPosition);
            this.toolOrientationDeviationLimitTransformGroup.setTransform(toolOrientationBoundaryTransform);
            this.limitTcpOrientationVector = toolOrientationLimit.getTCPOrientationVector().toVector3d();
        } else {
            Transform3D visualizationTransform = new Transform3D();
            this.toolOrientationDeviationLimitTransformGroup.getTransform(visualizationTransform);
            visualizationTransform.setTranslation(toolPosition);
            this.toolOrientationDeviationLimitTransformGroup.setTransform(visualizationTransform);
        }
        this.updateLimitCone(toolOrientationLimit);
        this.setLimitAppearance(toolOrientationLimit, markAsWarning);
        this.setLimitVisualizationVisibility(true);
    }

    public void updateLimitCone(ToolOrientationLimit toolOrientationLimit) {
        boolean limitChanged;
        boolean bl = limitChanged = this.toolDeviation != toolOrientationLimit.getMaximumTcpOrientationDeviation();
        if (limitChanged) {
            if (this.toolOrientationDeviationGeometryBranchGroup != null) {
                this.toolOrientationDeviationGeometryBranchGroup.detach();
                this.toolOrientationDeviationLimitTransformGroup.removeChild((Node)this.toolOrientationDeviationGeometryBranchGroup);
            }
            this.toolDeviation = toolOrientationLimit.getMaximumTcpOrientationDeviation();
            this.toolOrientationDeviationGeometryBranchGroup = this.createOrientationDeviationLimitGeometry(this.toolDeviation);
            this.toolOrientationDeviationLimitTransformGroup.addChild((Node)this.toolOrientationDeviationGeometryBranchGroup);
        }
    }

    public void clearVisualization() {
        this.setLimitVisualizationVisibility(false);
    }

    private static Appearance getOrientationDeviationLimitAppearance(AppearanceType appearanceType, TransparencyAttributes transparencyAttributes, RenderingAttributes renderingAttributes) {
        Material material;
        Appearance appearance = new Appearance();
        LineAttributes lineAttributes = new LineAttributes();
        lineAttributes.setLineWidth(5.0f);
        appearance.setLineAttributes(lineAttributes);
        switch (appearanceType) {
            case DISABLED: {
                material = MaterialDB.get((MaterialDB.MaterialID)MaterialDB.MaterialID.PEWTER);
                break;
            }
            case WARNING: {
                material = MaterialDB.get((MaterialDB.MaterialID)MaterialDB.MaterialID.RED_PLASTIC);
                break;
            }
            case ENABLED: {
                material = MaterialDB.get((MaterialDB.MaterialID)MaterialDB.MaterialID.YELLOW_PLASTIC);
                break;
            }
            default: {
                material = MaterialDB.get((MaterialDB.MaterialID)MaterialDB.MaterialID.YELLOW_PLASTIC);
            }
        }
        appearance.setMaterial(material);
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setRenderingAttributes(renderingAttributes);
        appearance.setCapability(1);
        appearance.setCapability(11);
        return appearance;
    }

    private void setLimitAppearance(ToolOrientationLimit toolOrientionLimit, boolean markAsWarning) {
        if (this.isMarkedAsWarning != markAsWarning || this.isDisplayingEnabledBoundary != toolOrientionLimit.isEnabled()) {
            Appearance apperance = !toolOrientionLimit.isEnabled() ? this.disabledOrientationDeviationLimitAppearance : (markAsWarning ? this.warningOrientationDeviationLimitAppearance : this.orientationDeviationLimitAppearance);
            this.toolOrientationDeviationGeometry.setAppearance(apperance);
            this.isMarkedAsWarning = markAsWarning;
            this.isDisplayingEnabledBoundary = toolOrientionLimit.isEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BranchGroup createOrientationDeviationLimitGeometry(double deviationAngle) {
        double thetaMin = 90.0 - Math.toDegrees(Math.min(Math.abs(deviationAngle), Math.PI));
        Appearance appearance = this.toolOrientationDeviationGeometry == null || this.toolOrientationDeviationGeometry.getAppearance() == null ? this.disabledOrientationDeviationLimitAppearance : this.toolOrientationDeviationGeometry.getAppearance();
        Object object = FREEHEP_JAVA3D_LIBRARY_LOCK;
        synchronized (object) {
            this.toolOrientationDeviationGeometry = new SphereSegment(0.0, 0.11, 0.0, 360.0, thetaMin, 89.999999999, 15, appearance);
        }
        this.toolOrientationDeviationGeometry.setCapability(14);
        this.toolOrientationDeviationGeometry.setCapability(15);
        BranchGroup branchGroup = ToolOrientationBoundaryVisualizer.createBranchGroup();
        branchGroup.addChild((Node)this.toolOrientationDeviationGeometry);
        return branchGroup;
    }

    private void setLimitVisualizationVisibility(boolean visible) {
        if (visible != this.RENDER_ATTRIBS_LIMIT.getVisible()) {
            this.RENDER_ATTRIBS_LIMIT.setVisible(visible);
        }
    }

    static BranchGroup createBranchGroup() {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        return branchGroup;
    }

    static TransformGroup createTransformGroup() {
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(18);
        transformGroup.setCapability(13);
        transformGroup.setCapability(14);
        return transformGroup;
    }

    static RenderingAttributes createRenderingAttributes() {
        RenderingAttributes renderingAttribs = new RenderingAttributes();
        renderingAttribs.setCapability(6);
        renderingAttribs.setVisible(false);
        return renderingAttribs;
    }

    private static enum AppearanceType {
        DISABLED,
        WARNING,
        ENABLED;

    }
}

