/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.checksum;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.polyscope.safety.checksum.SafetyChecksum;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.checksum.LegacyPresetSafetyChecksum;
import com.ur.safety.checksum.LegacySafetyChecksum;
import com.ur.safety.checksum.PresetSafetyChecksum;
import com.ur.safety.checksum.SafetyChecksumGenerator;
import com.ur.safety.checksum.SafetyChecksumImpl;
import javax.inject.Inject;
import javax.inject.Provider;

public class ChecksumGenerator {
    private final Provider<SafetySettingsLookupService> safetySettingsLookupServiceProvider;

    @Inject
    public ChecksumGenerator(Provider<SafetySettingsLookupService> safetySettingsLookupServiceProvider) {
        this.safetySettingsLookupServiceProvider = safetySettingsLookupServiceProvider;
    }

    public String generateCheckSumHTML(SafetySetup safety) {
        return this.generateSafetyChecksum(safety).toHTML();
    }

    public SafetyChecksum generateCheckSum(SafetySetup safety) {
        return this.generateSafetyChecksum(safety);
    }

    private SafetyChecksum generateSafetyChecksum(SafetySetup safetySetup) {
        if (safetySetup == null) {
            return SafetyChecksum.NULL;
        }
        if (this.isLegacySafetyChecksum(safetySetup)) {
            return this.createLegacySafetyChecksum(safetySetup);
        }
        return this.createSafetyCheckSum(safetySetup);
    }

    private boolean isLegacySafetyChecksum(SafetySetup safetySetup) {
        return this.getGenerator(safetySetup).checksumVersion().before(ChecksumVersion.VERSION_5_6);
    }

    private SafetyChecksum createLegacySafetyChecksum(SafetySetup safetySetup) {
        if (this.isPresetCheckSum(safetySetup)) {
            return new LegacyPresetSafetyChecksum(this.getGenerator(safetySetup), safetySetup);
        }
        return new LegacySafetyChecksum(this.getGenerator(safetySetup), safetySetup);
    }

    private SafetyChecksum createSafetyCheckSum(SafetySetup safetySetup) {
        if (this.isPresetCheckSum(safetySetup)) {
            return new PresetSafetyChecksum(this.getGenerator(safetySetup), safetySetup);
        }
        return new SafetyChecksumImpl(this.getGenerator(safetySetup), safetySetup);
    }

    private boolean isPresetCheckSum(SafetySetup safetySetup) {
        SafetyChecksumGenerator generator = this.getGenerator(safetySetup);
        String checksum = generator.generateChecksum(safetySetup);
        return generator.getVerySafePreset().equals(checksum) || generator.getLowSpeedPreset().equals(checksum) || generator.getDefaultPreset().equals(checksum) || generator.getFullSpeedPreset().equals(checksum);
    }

    private SafetyChecksumGenerator getGenerator(SafetySetup safetySetup) {
        return ((SafetySettingsLookupService)this.safetySettingsLookupServiceProvider.get()).getGenerators().get(((VersionComponent)safetySetup.getComponent(VersionComponent.class)).getChecksumVersion());
    }
}

