/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.checksum;

import com.ur.polyscope.controllerinterface.RobotModeListener;
import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.pin.IOAvailabilityChange;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumEvent;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumListener;
import com.ur.polyscope.safety.checksum.ChecksumService;
import com.ur.polyscope.safety.checksum.SafetyChecksum;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.checksum.ChecksumGenerator;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.util.Optional;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.view.constants.dev.RobotMode;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ChecksumServiceImpl
implements ChecksumService {
    private RobotMode robotMode = RobotMode.NO_CONTROLLER;
    private boolean safetyConfirmed = true;
    private SafetyChecksum activeSafetyChecksum = SafetyChecksum.NULL;
    private final SafetySettingsLookupService safetyLookupService;
    private final InstallationComponentLookup installationComponentLookup;
    private ChecksumGenerator checksumGenerator;

    @Inject
    private ChecksumServiceImpl(SafetySettingsLookupService safetyLookupService, InstallationComponentLookup installationComponentLookup, ChecksumGenerator checksumGenerator) {
        this.safetyLookupService = safetyLookupService;
        this.installationComponentLookup = installationComponentLookup;
        this.checksumGenerator = checksumGenerator;
        this.updateActiveSafetyChecksum();
        RobotModeListener robotModeListener = new RobotModeListener(){

            public void modeChanged(RobotMode oldValue, RobotMode newValue) {
                ChecksumServiceImpl.this.robotMode = newValue;
                ChecksumServiceImpl.this.updateActiveSafetyChecksum();
            }
        };
        EventNotificationService.register((Object)this, RobotModeListener.class, (Object)robotModeListener);
        SafetyChangeListener.Template safetyListener = new SafetyChangeListener.Template(){

            @Override
            public void safetyOnControllerConfirmed(SafetySetup setup) {
                ChecksumServiceImpl.this.safetyConfirmed = true;
                ChecksumServiceImpl.this.updateActiveSafetyChecksum();
            }

            @Override
            public void safetyRequestedToBeApplied(SafetySetup setup) {
                ChecksumServiceImpl.this.safetyConfirmed = false;
                ChecksumServiceImpl.this.updateActiveSafetyChecksum();
            }
        };
        EventNotificationService.register((Object)this, SafetyChangeListener.class, (Object)safetyListener);
    }

    public SafetyChecksum getActiveSafetyChecksum() {
        return this.activeSafetyChecksum;
    }

    private void updateActiveSafetyChecksum() {
        Optional<SafetySetup> safety;
        SafetyChecksum newChecksum = SafetyChecksum.NULL;
        if (this.safetyConfirmed && this.robotMode.getId() > RobotMode.CONFIRM_SAFETY.getId() && (safety = this.safetyLookupService.getControllerSafetySetup()).isPresent()) {
            newChecksum = this.checksumGenerator.generateCheckSum((SafetySetup)safety.get());
        }
        if (!newChecksum.equals(this.activeSafetyChecksum)) {
            this.activeSafetyChecksum = newChecksum;
            this.horribleEuromapHack();
            ActiveSafetyChecksumEvent event = new ActiveSafetyChecksumEvent();
            this.fireActiveSafetyChecksumChanged(event);
        }
    }

    private void horribleEuromapHack() {
        Immi euromap67 = (Immi)this.installationComponentLookup.getComponent(Immi.class);
        SafetySetup safetySetup = (SafetySetup)this.installationComponentLookup.getComponent(SafetySetup.class);
        euromap67.setImmiType(((SafetyMiscConfiguration)safetySetup.getComponent(SafetyMiscConfiguration.class)).getImmiType());
    }

    private void fireActiveSafetyChecksumChanged(final ActiveSafetyChecksumEvent event) {
        EventNotificationService.notify(ActiveSafetyChecksumListener.class, (NotificationStrategy)new NotificationStrategy<ActiveSafetyChecksumListener>(){

            public void notify(ActiveSafetyChecksumListener listener) {
                listener.activeSafetyChecksumChanged(event);
            }
        });
        EventNotificationService.notify(IOAvailabilityChange.class, (NotificationStrategy)new NotificationStrategy<IOAvailabilityChange>(){

            public void notify(IOAvailabilityChange listener) {
                listener.requestUpdateIOAvailability();
            }
        });
    }
}

