/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.checksum;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.SafetyChecksum;
import com.ur.safety.checksum.AbstractSafetyCheckSum;
import com.ur.safety.checksum.PresetNotFoundException;
import com.ur.safety.checksum.SafetyChecksumGenerator;
import java.awt.Color;
import javax.swing.UIManager;

public class LegacyPresetSafetyChecksum
extends AbstractSafetyCheckSum {
    private final SafetyChecksumGenerator generator;
    private final String presetChecksum;

    public LegacyPresetSafetyChecksum(SafetyChecksumGenerator generator, SafetySetup safetySetup) {
        this.generator = generator;
        this.presetChecksum = this.checksumToPreset(generator.generateChecksum(safetySetup));
    }

    private String checksumToPreset(String checksum) {
        if (this.generator.getVerySafePreset().equals(checksum)) {
            return "AAAA";
        }
        if (this.generator.getLowSpeedPreset().equals(checksum)) {
            return "BBBB";
        }
        if (this.generator.getDefaultPreset().equals(checksum)) {
            return "CCCC";
        }
        if (this.generator.getFullSpeedPreset().equals(checksum)) {
            return "DDDD";
        }
        throw new PresetNotFoundException();
    }

    public String getString() {
        return this.presetChecksum;
    }

    public int getLength() {
        return this.presetChecksum.length();
    }

    public char getLetter(int i) {
        return this.presetChecksum.charAt(i);
    }

    public Color getLetterColor(int i) {
        return UIManager.getColor("checksum.foreground");
    }

    public Color getBackgroundColor(int i) {
        return SafetyChecksum.TRANSPARENT_COLOR;
    }
}

