/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.checksum;

import com.ur.lang.StringUtils;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.checksum.AbstractSafetyCheckSum;
import com.ur.safety.checksum.SafetyChecksumGenerator;
import java.awt.Color;

public class LegacySafetyChecksum
extends AbstractSafetyCheckSum {
    private final String checksum;
    private final String colourCodes;
    private static final String[] LETTER_COLOURS = new String[]{"#000000", "#000000", "#000000", "#000000", "#000000", "#000000", "#000000", "#000000", "#000000", "#000000", "#FFFFFF", "#FFFFFF", "#FFFFFF", "#FFFFFF", "#FFFFFF", "#FFFFFF"};
    private static final String[] BACKGROUND_COLOURS = new String[]{"#6495ED", "#DDA0DD", "#ADFF2F", "#C0C0C0", "#00FF7F", "#32cd32", "#BDB76B", "#FFFFFF", "#CD5C5C", "#D2691E", "#000000", "#AA11AA", "#006400", "#980000", "#CC66FF", "#FF0066"};

    public LegacySafetyChecksum(SafetyChecksumGenerator generator, SafetySetup safetySetup) {
        long longChecksum = Long.parseLong(generator.generateChecksum(safetySetup));
        this.checksum = StringUtils.padLeftWith((String)Long.toHexString(longChecksum >> 16), (String)"0", (int)4).toUpperCase();
        this.colourCodes = StringUtils.padLeftWith((String)Long.toHexString(longChecksum & 0xFFFFL), (String)"0", (int)4);
    }

    public String getString() {
        return this.checksum;
    }

    public int getLength() {
        return this.checksum.length();
    }

    public char getLetter(int index) {
        return this.checksum.charAt(index);
    }

    private char getColourCode(int index) {
        return this.colourCodes.charAt(index);
    }

    public Color getLetterColor(int index) {
        return Color.decode(LETTER_COLOURS[Character.digit(this.getColourCode(index), 16)]);
    }

    public Color getBackgroundColor(int index) {
        return Color.decode(BACKGROUND_COLOURS[Character.digit(this.getColourCode(index), 16)]);
    }
}

