/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.checksum;

import com.ur.polyscope.safety.checksum.SafetyChecksum;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;

public class LegacySafetyChecksumIcon
implements Icon {
    private static final int ICON_SIZE = 48;
    private static final float FONT_SIZE = 16.0f;
    private final SafetyChecksum checksum;

    public LegacySafetyChecksumIcon(SafetyChecksum checksum) {
        this.checksum = checksum;
    }

    @Override
    public int getIconWidth() {
        return 48;
    }

    @Override
    public int getIconHeight() {
        return this.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics graphics, int x, int y) {
        Graphics2D g = (Graphics2D)graphics;
        this.configureFonts(g);
        this.paintGrid(g, x, y);
    }

    private void configureFonts(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font font = g2.getFont().deriveFont(1).deriveFont(16.0f);
        g2.setFont(font);
    }

    private void paintGrid(Graphics2D g, int x, int y) {
        int cellCountSqrt = (int)Math.ceil(Math.sqrt(this.checksum.getLength()));
        int cellSize = 48 / cellCountSqrt;
        int cell = 0;
        int cellY = 0;
        while (cellY < cellCountSqrt) {
            int cellX = 0;
            while (cellX < cellCountSqrt) {
                if (cell < this.checksum.getLength()) {
                    int cx = x + cellX * cellSize;
                    int cy = y + cellY * cellSize;
                    this.paintLetter(g, cx, cy, cellSize, cellSize, String.valueOf(this.checksum.getLetter(cell)), this.checksum.getLetterColor(cell), this.checksum.getBackgroundColor(cell));
                }
                ++cell;
                ++cellX;
            }
            ++cellY;
        }
    }

    private void paintLetter(Graphics2D g, int x, int y, int w, int h, String letter, Color letterColor, Color backgroundColor) {
        g.setColor(backgroundColor);
        g.fillRect(x, y, w, h);
        FontMetrics fm = g.getFontMetrics();
        int letterHeight = fm.getAscent();
        int letterWidth = fm.stringWidth(letter);
        g.setColor(letterColor);
        double letterX = x + (w - letterWidth) / 2;
        double letterY = y + (h - letterHeight) / 2 + letterHeight;
        g.drawString(letter, (int)letterX, (int)letterY);
    }
}

