/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.checksum;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.SafetyChecksum;
import com.ur.safety.checksum.AbstractSafetyCheckSum;
import com.ur.safety.checksum.PresetNotFoundException;
import com.ur.safety.checksum.SafetyChecksumGenerator;
import java.awt.Color;
import javax.swing.UIManager;

public class PresetSafetyChecksum
extends AbstractSafetyCheckSum {
    private final String presetChecksum;
    private final SafetyChecksumGenerator generator;

    public PresetSafetyChecksum(SafetyChecksumGenerator generator, SafetySetup safetySetup) {
        this.generator = generator;
        this.presetChecksum = this.checksumToPreset(generator.generateChecksum(safetySetup));
    }

    private String checksumToPreset(String checksum) {
        if (this.generator.getVerySafePreset().equals(checksum)) {
            return "AAAAAAAA";
        }
        if (this.generator.getLowSpeedPreset().equals(checksum)) {
            return "BBBBBBBB";
        }
        if (this.generator.getDefaultPreset().equals(checksum)) {
            return "CCCCCCCC";
        }
        if (this.generator.getFullSpeedPreset().equals(checksum)) {
            return "DDDDDDDD";
        }
        throw new PresetNotFoundException();
    }

    public String getString() {
        return this.presetChecksum;
    }

    public int getLength() {
        return this.presetChecksum.length();
    }

    public char getLetter(int i) {
        return this.presetChecksum.charAt(i);
    }

    public Color getLetterColor(int i) {
        return UIManager.getColor("checksum.foreground");
    }

    public Color getBackgroundColor(int i) {
        return SafetyChecksum.TRANSPARENT_COLOR;
    }
}

