/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.checksum;

import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.polyscope.safety.checksum.SafetyChecksum;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.checksum.LegacySafetyChecksumIcon;
import com.ur.safety.checksum.SafetyChecksumIcon;
import javax.inject.Inject;
import javax.swing.Icon;

public class SafetyChecksumIconFactory {
    private SafetySettingsLookupService lookupService;

    @Inject
    public SafetyChecksumIconFactory(SafetySettingsLookupService lookupService) {
        this.lookupService = lookupService;
    }

    public Icon createSafetyChecksumIcon(SafetyChecksum safetyChecksum) {
        if (this.isLegacyChecksumVersion()) {
            return new LegacySafetyChecksumIcon(safetyChecksum);
        }
        return new SafetyChecksumIcon(safetyChecksum);
    }

    private boolean isLegacyChecksumVersion() {
        ChecksumVersion version = this.lookupService.getSafetyComponent(VersionComponent.class).getChecksumVersion();
        return version.before(ChecksumVersion.VERSION_5_6);
    }
}

