/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.checksum;

import com.ur.lang.StringUtils;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.SafetyChecksum;
import com.ur.safety.checksum.AbstractSafetyCheckSum;
import com.ur.safety.checksum.SafetyChecksumGenerator;
import java.awt.Color;
import javax.swing.UIManager;

class SafetyChecksumImpl
extends AbstractSafetyCheckSum {
    private final String checksum;

    SafetyChecksumImpl(SafetyChecksumGenerator generator, SafetySetup safetySetup) {
        long longChecksym = Long.parseLong(generator.generateChecksum(safetySetup));
        this.checksum = StringUtils.padLeftWith((String)Long.toHexString(longChecksym), (String)"0", (int)8).toUpperCase();
    }

    public String getString() {
        return this.checksum;
    }

    public int getLength() {
        return this.checksum.length();
    }

    public char getLetter(int index) {
        return this.checksum.charAt(index);
    }

    public Color getLetterColor(int index) {
        return UIManager.getColor("checksum.foreground");
    }

    public Color getBackgroundColor(int index) {
        return SafetyChecksum.TRANSPARENT_COLOR;
    }
}

