/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.checksum;

import com.ur.lang.EqualsUtil;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageProducer;
import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.RobotModeListener;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.SafetyActionFactory;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.checksum.ChecksumGenerator;
import com.ur.safety.controllerinterface.SafetyRequestFromController;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.Optional;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.swing.HTML;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.errorcodes.ReportLevel;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;

@Singleton
@Extension(value="MenuBar")
public class SafetyChecksumMenuContribution
extends JLabel
implements MenuExtension {
    private static final Dimension CHECKSUM_LABEL_SIZE = new Dimension(60, 30);
    private final SafetySettingsLookupService safetyLookup;
    private final SafetyRequestFromController safetyRequestFromController;
    private boolean isDisplayingChecksum = false;
    private final HelpIdAssigner helpIdAssigner;
    private final SafetyTextResource textResource;
    private final ErrorDialogCreator dialogCreator;
    private ChecksumGenerator checksumGenerator;

    @Inject
    public SafetyChecksumMenuContribution(SafetySettingsLookupService safetyLookup, SafetyActionFactory actionFactory, SafetyRequestFromController safetyRequestFromController, ViewContext viewContext, ErrorDialogCreator dialogCreator, ChecksumGenerator checksumGenerator) {
        this.safetyRequestFromController = safetyRequestFromController;
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.textResource = (SafetyTextResource)viewContext.getTextResource(SafetyTextResource.class);
        this.dialogCreator = dialogCreator;
        this.checksumGenerator = checksumGenerator;
        EventNotificationService.register((Object)this, SafetyChangeListener.class, (Object)new UpdateChecksumWhenControllerUpdated());
        EventNotificationService.register((Object)this, RobotModeListener.class, (Object)new ResetChecksumWhenDisconnectedFromController());
        this.safetyLookup = safetyLookup;
        Optional<SafetySetup> controllerSafetySetup = safetyLookup.getControllerSafetySetup();
        if (controllerSafetySetup.isPresent()) {
            this.calculateChecksum((SafetySetup)controllerSafetySetup.get());
        } else {
            this.calculateChecksum(null);
        }
        this.initHelpIds();
        final Action action = actionFactory.createShowActiveSafetyLimitsAction(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SafetyChecksumMenuContribution.this.isDisplayingChecksum) {
                    action.actionPerformed(null);
                }
            }
        });
    }

    protected void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this, "gui:safety_checksum");
    }

    private void calculateChecksum(SafetySetup setup) {
        String beautifiedCheckSum = this.checksumGenerator.generateCheckSumHTML(setup);
        this.setText(this.createCheckSumLabelText(beautifiedCheckSum));
        this.setPreferredSize(CHECKSUM_LABEL_SIZE);
        this.setMinimumSize(CHECKSUM_LABEL_SIZE);
        this.setMaximumSize(CHECKSUM_LABEL_SIZE);
        this.setHorizontalAlignment(0);
        this.isDisplayingChecksum = setup != null;
    }

    private String createCheckSumLabelText(String checkSum) {
        return HTML.html((String)HTML.fontBold((String)HTML.fontSize((String)"+1", (String)checkSum)));
    }

    public MenuExtension.MenuContribution create() {
        return MenuExtension.MenuContribution.locateAfter((int)2000, (MenuExtension.MenuContribution)new MenuExtension.MenuContribution(null, "PostFix"){

            public JComponent createComponent(Action action) {
                return SafetyChecksumMenuContribution.this;
            }
        });
    }

    private final class ResetChecksumWhenDisconnectedFromController
    implements RobotModeListener {
        private ResetChecksumWhenDisconnectedFromController() {
        }

        public void modeChanged(RobotMode oldValue, RobotMode newValue) {
            if (EqualsUtil.equalsOneOf((Object)newValue, (Object[])new RobotMode[]{RobotMode.NO_CONTROLLER, RobotMode.DISCONNECTED})) {
                SafetyChecksumMenuContribution.this.calculateChecksum(null);
            } else if (RobotMode.CONFIRM_SAFETY.getId() == newValue.getId()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        boolean done = false;
                        int i = 0;
                        while (i < 10) {
                            if (SafetyChecksumMenuContribution.this.safetyRequestFromController.requestSafetySetup()) {
                                done = true;
                                break;
                            }
                            Waiting.pause((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                            ++i;
                        }
                        if (EqualsUtil.equalsOneOf((Object)RobotState.getLatestRobotState().robotMode, (Object[])new RobotMode[]{RobotMode.NO_CONTROLLER, RobotMode.DISCONNECTED})) {
                            SafetyChecksumMenuContribution.this.calculateChecksum(null);
                        } else if (!done) {
                            RobotMessage rm = new RobotMessageProducer().generateAndNotify(ReportLevel.FAULT, SafetyChecksumMenuContribution.this.textResource.safetySetupFailedExplanation());
                            rm.warningLevel = ReportLevel.FAULT;
                            rm.notifyAllSubscribers();
                            ErrorMessage errorMessage = new ErrorMessage(DialogWithName.SAFETY.getName(), SafetyChecksumMenuContribution.this.textResource.safetySetupFailedTitle(), SafetyChecksumMenuContribution.this.textResource.safetySetupFailedExplanation(), SafetyChecksumMenuContribution.this.textResource.safetySetupFailedSuggestion());
                            SafetyChecksumMenuContribution.this.dialogCreator.showErrorDialog(errorMessage, new OkDialogListener());
                        }
                    }
                }).start();
            } else if (!SafetyChecksumMenuContribution.this.isDisplayingChecksum && RobotMode.CONFIRM_SAFETY.getId() < newValue.getId()) {
                Optional<SafetySetup> controllerSafetySetup = SafetyChecksumMenuContribution.this.safetyLookup.getControllerSafetySetup();
                if (controllerSafetySetup.isPresent()) {
                    SafetyChecksumMenuContribution.this.calculateChecksum((SafetySetup)controllerSafetySetup.get());
                } else {
                    SafetyChecksumMenuContribution.this.calculateChecksum(null);
                }
            }
        }
    }

    private final class UpdateChecksumWhenControllerUpdated
    extends SafetyChangeListener.Template {
        private UpdateChecksumWhenControllerUpdated() {
        }

        @Override
        public void safetyOnControllerConfirmed(SafetySetup setup) {
            SafetyChecksumMenuContribution.this.calculateChecksum(setup);
        }

        @Override
        public void safetyRequestedToBeApplied(SafetySetup setup) {
            SafetyChecksumMenuContribution.this.calculateChecksum(null);
        }
    }
}

