/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.checksum;

import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.safety.SafetySetupContribution;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.polyscope.safety.checksum.SafetyFeatureSupport;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.polyscope.safety.version.SafetyControlBoardVersionSite;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.Settings;
import com.ur.safety.installation.SafetySetupConverter;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class VersionContribution
implements SafetySetupContribution<VersionComponent>,
SafetySetupConverter<VersionComponent> {
    public static final String SAFETY_CRC_VERSION_KEY = "version";
    public static final String SAFETY_CRC_KEY = "crc";
    public static final String SAFETY_CHECKSUM_SECTION = "Safety Checksum";
    private SafetyControlBoardVersionSite versionSite;

    @Inject
    public VersionContribution(SafetyControlBoardVersionSite versionSite) {
        this.versionSite = versionSite;
    }

    @Override
    public Class<VersionComponent> getComponentType() {
        return VersionComponent.class;
    }

    public VersionComponent createDefaultComponent() {
        ChecksumVersion checksumVersion = this.versionSite.getSafetyFeatureSupport().latestChecksum();
        boolean checksumVersionSpecified = this.versionSite.getSafetyFeatureSupport() != SafetyFeatureSupport.UNKNOWN;
        return new VersionComponent(checksumVersion, checksumVersionSpecified);
    }

    public VersionComponent readFromOptions(ChecksumVersion version, Options options) {
        OptionsSection safetyChecksumProperties = options.getSection(SAFETY_CHECKSUM_SECTION);
        VersionComponent versionComponent = this.createDefaultComponent();
        versionComponent.setChecksumVersion(version);
        versionComponent.setCRCValue(safetyChecksumProperties.getString(SAFETY_CRC_KEY, ""));
        versionComponent.setVerified(options);
        return versionComponent;
    }

    public void copyToOptions(ChecksumVersion checksumVersion, Options options, VersionComponent component) {
        options.getSection("SafetySetup").setBoolean("verified", Boolean.valueOf(component.isVerified()));
        options.getSection(SAFETY_CHECKSUM_SECTION).setString(SAFETY_CRC_VERSION_KEY, component.getChecksumVersion().toString());
    }

    public void copyControllerRepresentationTo(ChecksumVersion checksumVersion, Options options, VersionComponent component) {
    }

    @Override
    public void convertToG5(VersionComponent versionComponent) {
        versionComponent.setChecksumVersion(Settings.getLatestChecksumVersion());
        versionComponent.setVerified(false);
    }

    @Override
    public List<String> getAffectedG3SafetyItems(VersionComponent versionComponent, SafetyTextResource textResource) {
        return Collections.emptyList();
    }

    public boolean isSupported(ChecksumVersion version) {
        return true;
    }
}

