/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.checksum.impl;

import com.ur.lang.CRCUtils;
import com.ur.lang.EndianConverter;
import com.ur.math.Revolution;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.robot.configuration.RobotChecksum;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.SafetySetupComponent;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.boundaries.domain.PlanesChecksumContribution_1_0;
import com.ur.safety.boundaries.domain.ToolOrientationChecksumContribution;
import com.ur.safety.checksum.SafetyChecksumGenerator;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.view.constants.dev.SafetyMode;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SafetyChecksumGenerator_1_0
implements SafetyChecksumGenerator {
    protected static final CRCUtils crc = new CRCUtils();
    private final ChecksumVersion version;
    private final Iterable<ChecksumGeneratorContribution> contributions;
    private final EndianConverter converter;
    protected final RobotChecksum robotChecksum;

    public SafetyChecksumGenerator_1_0(RobotChecksum robotChecksum) {
        this(ChecksumVersion.VERSION_1_0, robotChecksum, (EndianConverter)new EndianConverter.LittleEndian(), new MiscSetupChecksumContribution(), new IOChecksumContribution(), new PlanesChecksumContribution_1_0(SafetyLimitMode.TRIGGER), new GeneralLimitsContribution(SafetyMode.NORMAL), new PlanesChecksumContribution_1_0(SafetyLimitMode.NORMAL), new ToolOrientationChecksumContribution(SafetyLimitMode.NORMAL), new JointLimitsChecksumContribution(SafetyMode.NORMAL), new GeneralLimitsContribution(SafetyMode.REDUCED), new PlanesChecksumContribution_1_0(SafetyLimitMode.REDUCED), new ToolOrientationChecksumContribution(SafetyLimitMode.REDUCED), new JointLimitsChecksumContribution(SafetyMode.REDUCED));
    }

    SafetyChecksumGenerator_1_0(ChecksumVersion version, RobotChecksum robotChecksum, EndianConverter converter, ChecksumGeneratorContribution ... contributions) {
        this.version = version;
        this.robotChecksum = robotChecksum;
        this.converter = converter;
        this.contributions = Arrays.asList(contributions);
    }

    @Override
    public ChecksumVersion checksumVersion() {
        return this.version;
    }

    @Override
    public String generateChecksum(SafetySetup safety) {
        try {
            ByteBuffer buffer = this.allocateByteBuffer(safety);
            for (ChecksumGeneratorContribution each : this.contributions) {
                this.addBytes(each, buffer, safety);
            }
            return this.asUnsignedInteger(crc.crc32Fast(-1, buffer));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate Checksum for " + ((VersionComponent)safety.getComponent(VersionComponent.class)).getChecksumVersion(), e);
        }
    }

    private <T extends SafetySetupComponent> void addBytes(ChecksumGeneratorContribution<T> contribution, ByteBuffer buffer, SafetySetup safety) {
        contribution.addBytes(this.converter, buffer, safety.getComponent(contribution.getComponentType()));
    }

    private ByteBuffer allocateByteBuffer(SafetySetup safetySetup) {
        int bufferSize = this.getBufferSize(safetySetup);
        return ByteBuffer.allocate(bufferSize);
    }

    public int getBufferSize(SafetySetup safetySetup) {
        int bufferSize = 0;
        for (ChecksumGeneratorContribution each : this.contributions) {
            each.setSafetySetup(safetySetup);
            bufferSize += each.getByteCount();
        }
        return bufferSize;
    }

    public String asUnsignedInteger(int crc32Fast) {
        return String.valueOf(ByteBuffer.allocate(8).putInt(4, crc32Fast).getLong(0));
    }

    @Override
    public String getDefaultPreset() {
        return this.robotChecksum.getDefaultPreset_1_0();
    }

    @Override
    public String getFullSpeedPreset() {
        return this.robotChecksum.getFullSpeedPreset_1_0();
    }

    @Override
    public String getLowSpeedPreset() {
        return this.robotChecksum.getLowSpeedPreset_1_0();
    }

    @Override
    public String getVerySafePreset() {
        return this.robotChecksum.getVerySafePreset_1_0();
    }

    public static interface ChecksumGeneratorContribution<T extends SafetySetupComponent> {
        public Class<T> getComponentType();

        public int getByteCount();

        public void addBytes(EndianConverter var1, ByteBuffer var2, T var3);

        default public void setSafetySetup(SafetySetup safetySetup) {
        }
    }

    public static abstract class DefaultChecksumGeneratorContribution<T extends SafetySetupComponent>
    implements ChecksumGeneratorContribution<T> {
        private final Class<T> c;
        private final int byteCount;

        public DefaultChecksumGeneratorContribution(Class<T> c, int byteCount) {
            this.c = c;
            this.byteCount = byteCount;
        }

        @Override
        public Class<T> getComponentType() {
            return this.c;
        }

        @Override
        public int getByteCount() {
            return this.byteCount;
        }
    }

    static class GeneralLimitsContribution
    implements ChecksumGeneratorContribution<SafetyLimitsComponent> {
        private final SafetyMode mode;

        GeneralLimitsContribution(SafetyMode mode) {
            this.mode = mode;
        }

        @Override
        public Class<SafetyLimitsComponent> getComponentType() {
            return SafetyLimitsComponent.class;
        }

        @Override
        public int getByteCount() {
            return 16;
        }

        @Override
        public void addBytes(EndianConverter converter, ByteBuffer buffer, SafetyLimitsComponent component) {
            SafetyLimits limits = this.mode == SafetyMode.NORMAL ? component.getNormalLimits() : component.getReducedLimits();
            converter.convert(buffer, (float)limits.getMaxToolSpeed());
            converter.convert(buffer, (float)limits.getMaxToolForce());
            converter.convert(buffer, (float)limits.getMaxPower());
            converter.convert(buffer, (float)limits.getMaxMomentum());
        }
    }

    static class IOChecksumContribution
    implements ChecksumGeneratorContribution<SafetyIOConfiguration> {
        IOChecksumContribution() {
        }

        @Override
        public Class<SafetyIOConfiguration> getComponentType() {
            return SafetyIOConfiguration.class;
        }

        @Override
        public int getByteCount() {
            return 16;
        }

        @Override
        public void addBytes(EndianConverter converter, ByteBuffer buffer, SafetyIOConfiguration io) {
            buffer.put((byte)io.getEmergencyStopInputs().getA());
            buffer.put((byte)io.getEmergencyStopInputs().getB());
            buffer.put((byte)io.getReducedModeInputs().getA());
            buffer.put((byte)io.getReducedModeInputs().getB());
            buffer.put((byte)io.getSafeguardStopResetInputs().getA());
            buffer.put((byte)io.getSafeguardStopResetInputs().getB());
            buffer.put((byte)io.getSystemEmergencyStopOutputs().getA());
            buffer.put((byte)io.getSystemEmergencyStopOutputs().getB());
            buffer.put((byte)io.getRobotMovingOutputs().getA());
            buffer.put((byte)io.getRobotMovingOutputs().getB());
            buffer.put((byte)io.getRobotNotStoppingOutputs().getA());
            buffer.put((byte)io.getRobotNotStoppingOutputs().getB());
            buffer.put((byte)io.getReducedModeOutputs().getA());
            buffer.put((byte)io.getReducedModeOutputs().getB());
            buffer.put((byte)io.getNotReducedModeOutputs().getA());
            buffer.put((byte)io.getNotReducedModeOutputs().getB());
        }
    }

    static class JointLimitsChecksumContribution
    implements ChecksumGeneratorContribution<SafetyLimitsComponent> {
        protected static final int NUMBER_OF_JOINTS = 6;
        protected static final int NUMBER_OF_BYTES_FOR_A_JOINT = 120;
        private final SafetyMode mode;

        JointLimitsChecksumContribution(SafetyMode mode) {
            this.mode = mode;
        }

        @Override
        public Class<SafetyLimitsComponent> getComponentType() {
            return SafetyLimitsComponent.class;
        }

        @Override
        public int getByteCount() {
            return 120;
        }

        @Override
        public void addBytes(EndianConverter converter, ByteBuffer buffer, SafetyLimitsComponent component) {
            Revolution v;
            SafetyLimits limits = this.mode == SafetyMode.NORMAL ? component.getNormalLimits() : component.getReducedLimits();
            int i = 0;
            while (i < 6) {
                converter.convert(buffer, (float)limits.getMaxJointSpeeds()[i]);
                ++i;
            }
            i = 0;
            while (i < 6) {
                v = limits.getMinJointPosition(JointType.fromJointNumber((int)i));
                buffer.putInt(converter.convert(URMath.revolutionsFromRadiansLegacy3_0((double)v.getTotalAngle())));
                ++i;
            }
            i = 0;
            while (i < 6) {
                v = limits.getMinJointPosition(JointType.fromJointNumber((int)i));
                converter.convert(buffer, (float)URMath.normalizeInRadiansLegacy3_0((double)v.getTotalAngle()));
                ++i;
            }
            i = 0;
            while (i < 6) {
                v = limits.getMaxJointPosition(JointType.fromJointNumber((int)i));
                buffer.putInt(converter.convert(URMath.revolutionsFromRadiansLegacy3_0((double)v.getTotalAngle())));
                ++i;
            }
            i = 0;
            while (i < 6) {
                v = limits.getMaxJointPosition(JointType.fromJointNumber((int)i));
                converter.convert(buffer, (float)URMath.normalizeInRadiansLegacy3_0((double)v.getTotalAngle()));
                ++i;
            }
        }
    }

    static class MiscSetupChecksumContribution
    implements ChecksumGeneratorContribution<SafetyMiscConfiguration> {
        MiscSetupChecksumContribution() {
        }

        @Override
        public Class<SafetyMiscConfiguration> getComponentType() {
            return SafetyMiscConfiguration.class;
        }

        @Override
        public int getByteCount() {
            return 2;
        }

        @Override
        public void addBytes(EndianConverter converter, ByteBuffer buffer, SafetyMiscConfiguration misc) {
            buffer.put((byte)misc.getTeachPendant().getId());
            buffer.put((byte)misc.getImmiType().getId());
        }
    }
}

