/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.checksum.impl;

import com.ur.lang.EndianConverter;
import com.ur.math.Revolution;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.robot.configuration.RobotChecksum;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.boundaries.domain.PlanesChecksumContribution_1_0;
import com.ur.safety.boundaries.domain.ToolOrientationChecksumContribution;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_1_0;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.view.constants.dev.SafetyMode;
import java.nio.ByteBuffer;

public class SafetyChecksumGenerator_3_1
extends SafetyChecksumGenerator_1_0 {
    public SafetyChecksumGenerator_3_1(RobotChecksum robotChecksum) {
        super(ChecksumVersion.VERSION_3_1, robotChecksum, (EndianConverter)new EndianConverter.LittleEndian(), new SafetyChecksumGenerator_1_0.MiscSetupChecksumContribution(), new SafetyChecksumGenerator_1_0.IOChecksumContribution(), new PlanesChecksumContribution_1_0(SafetyLimitMode.TRIGGER), new SafetyChecksumGenerator_1_0.GeneralLimitsContribution(SafetyMode.NORMAL), new PlanesChecksumContribution_1_0(SafetyLimitMode.NORMAL), new ToolOrientationChecksumContribution(SafetyLimitMode.NORMAL), new JointLimitsChecksumContribution_3_1(SafetyMode.NORMAL), new SafetyChecksumGenerator_1_0.GeneralLimitsContribution(SafetyMode.REDUCED), new PlanesChecksumContribution_1_0(SafetyLimitMode.REDUCED), new ToolOrientationChecksumContribution(SafetyLimitMode.REDUCED), new JointLimitsChecksumContribution_3_1(SafetyMode.REDUCED));
    }

    SafetyChecksumGenerator_3_1(ChecksumVersion version, RobotChecksum robotChecksum, EndianConverter converter, SafetyChecksumGenerator_1_0.ChecksumGeneratorContribution ... contributions) {
        super(version, robotChecksum, converter, contributions);
    }

    static class JointLimitsChecksumContribution_3_1
    extends SafetyChecksumGenerator_1_0.JointLimitsChecksumContribution {
        private final SafetyMode mode;

        JointLimitsChecksumContribution_3_1(SafetyMode mode) {
            super(mode);
            this.mode = mode;
        }

        @Override
        public void addBytes(EndianConverter converter, ByteBuffer buffer, SafetyLimitsComponent component) {
            Revolution jointRevolution;
            SafetyLimits limits = this.mode == SafetyMode.NORMAL ? component.getNormalLimits() : component.getReducedLimits();
            int i = 0;
            while (i < 6) {
                converter.convert(buffer, (float)limits.getMaxJointSpeeds()[i]);
                ++i;
            }
            i = 0;
            while (i < 6) {
                jointRevolution = limits.getMinJointPosition(JointType.fromJointNumber((int)i));
                buffer.putInt(converter.convert(jointRevolution.getRevolutions()));
                ++i;
            }
            i = 0;
            while (i < 6) {
                jointRevolution = limits.getMinJointPosition(JointType.fromJointNumber((int)i));
                converter.convert(buffer, (float)jointRevolution.getOffsetAngle());
                ++i;
            }
            i = 0;
            while (i < 6) {
                jointRevolution = limits.getMaxJointPosition(JointType.fromJointNumber((int)i));
                buffer.putInt(converter.convert(jointRevolution.getRevolutions()));
                ++i;
            }
            i = 0;
            while (i < 6) {
                jointRevolution = limits.getMaxJointPosition(JointType.fromJointNumber((int)i));
                converter.convert(buffer, (float)jointRevolution.getOffsetAngle());
                ++i;
            }
        }
    }
}

