/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.checksum.impl;

import com.ur.lang.EndianConverter;
import com.ur.polyscope.robot.configuration.FactoryPresetLimits;
import com.ur.polyscope.robot.configuration.RobotChecksum;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyEndianConverter;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.boundaries.domain.PlanesChecksumContribution_5_0;
import com.ur.safety.boundaries.domain.ToolOrientationChecksumContribution;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_1_0;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_3_1;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_5_0;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_5_4;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.safehome.SafeHomeChecksumContribution;
import com.ur.safety.threepositionenabling.application.ThreePositionEnablingChecksumContribution;
import com.ur.safety.workpiece.domain.WorkpieceChecksumContribution;
import com.ur.view.constants.dev.SafetyMode;
import java.nio.ByteBuffer;
import javax.inject.Inject;

public class SafetyChecksumGenerator_5_5
extends SafetyChecksumGenerator_5_4 {
    @Inject
    public SafetyChecksumGenerator_5_5(SafetyEndianConverter safetyEndianConverter, RobotChecksum robotChecksum) {
        super(ChecksumVersion.VERSION_5_5, robotChecksum, safetyEndianConverter.getConverter(), new SafetyChecksumGenerator_1_0.MiscSetupChecksumContribution(), new SafetyChecksumGenerator_5_4.IOChecksumContribution_5_4(), new PlanesChecksumContribution_5_0(SafetyLimitMode.TRIGGER), new WorkpieceChecksumContribution(), new SafeHomeChecksumContribution(), new ThreePositionEnablingChecksumContribution(), new OSSDChecksumContribution(), new SafetyChecksumGenerator_5_0.GeneralLimitsContribution_5_0(SafetyMode.NORMAL), new PlanesChecksumContribution_5_0(SafetyLimitMode.NORMAL), new ToolOrientationChecksumContribution(SafetyLimitMode.NORMAL), new SafetyChecksumGenerator_3_1.JointLimitsChecksumContribution_3_1(SafetyMode.NORMAL), new SafetyChecksumGenerator_5_0.GeneralLimitsContribution_5_0(SafetyMode.REDUCED), new PlanesChecksumContribution_5_0(SafetyLimitMode.REDUCED), new ToolOrientationChecksumContribution(SafetyLimitMode.REDUCED), new SafetyChecksumGenerator_3_1.JointLimitsChecksumContribution_3_1(SafetyMode.REDUCED));
    }

    SafetyChecksumGenerator_5_5(ChecksumVersion version, RobotChecksum robotChecksum, EndianConverter converter, SafetyChecksumGenerator_1_0.ChecksumGeneratorContribution ... contributions) {
        super(version, robotChecksum, converter, contributions);
    }

    @Override
    public String getDefaultPreset() {
        return this.robotChecksum.getPreset(FactoryPresetLimits.DEFAULT, 5, 5);
    }

    @Override
    public String getFullSpeedPreset() {
        return this.robotChecksum.getPreset(FactoryPresetLimits.FULL_SPEED, 5, 5);
    }

    @Override
    public String getLowSpeedPreset() {
        return this.robotChecksum.getPreset(FactoryPresetLimits.LOW_SPEED, 5, 5);
    }

    @Override
    public String getVerySafePreset() {
        return this.robotChecksum.getPreset(FactoryPresetLimits.VERY_SAFE, 5, 5);
    }

    static class OSSDChecksumContribution
    extends SafetyChecksumGenerator_1_0.DefaultChecksumGeneratorContribution<SafetyIOConfiguration> {
        private static final int BYTE_COUNT = 1;

        OSSDChecksumContribution() {
            super(SafetyIOConfiguration.class, 1);
        }

        @Override
        public void addBytes(EndianConverter converter, ByteBuffer buffer, SafetyIOConfiguration component) {
            byte b = 0;
            boolean[] ossd = component.getOSSDs();
            int i = 0;
            while (i < ossd.length) {
                if (ossd[i]) {
                    b = (byte)(b | 1 << i);
                }
                ++i;
            }
            buffer.put(b);
        }
    }
}

