/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.controllerinterface;

import java.io.DataInput;
import java.io.IOException;

public class CountingDataInput
implements DataInput {
    private final DataInput dataInput;
    private int bytesRead = 0;

    public CountingDataInput(DataInput dataInput) {
        this.dataInput = dataInput;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.dataInput.readFully(b);
        this.bytesRead += b.length;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dataInput.readFully(b, off, len);
        this.bytesRead += len;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int bytesSkipped = this.dataInput.skipBytes(n);
        this.bytesRead += bytesSkipped;
        return bytesSkipped;
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean result = this.dataInput.readBoolean();
        ++this.bytesRead;
        return result;
    }

    @Override
    public byte readByte() throws IOException {
        byte result = this.dataInput.readByte();
        ++this.bytesRead;
        return result;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int result = this.dataInput.readUnsignedByte();
        ++this.bytesRead;
        return result;
    }

    @Override
    public short readShort() throws IOException {
        short result = this.dataInput.readShort();
        this.bytesRead += 2;
        return result;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int result = this.dataInput.readUnsignedShort();
        this.bytesRead += 2;
        return result;
    }

    @Override
    public char readChar() throws IOException {
        char result = this.dataInput.readChar();
        this.bytesRead += 2;
        return result;
    }

    @Override
    public int readInt() throws IOException {
        int result = this.dataInput.readInt();
        this.bytesRead += 4;
        return result;
    }

    @Override
    public long readLong() throws IOException {
        long result = this.dataInput.readLong();
        this.bytesRead += 8;
        return result;
    }

    @Override
    public float readFloat() throws IOException {
        float result = this.dataInput.readFloat();
        this.bytesRead += 4;
        return result;
    }

    @Override
    public double readDouble() throws IOException {
        double result = this.dataInput.readDouble();
        this.bytesRead += 8;
        return result;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }
}

