/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.controllerinterface;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.MessageConsumer;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.tolerances.SafetyComplianceToleranceMessage;
import com.ur.safety.tolerances.SafetyComplianceTolerances;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import com.ur.view.constants.comm.MessageType;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;

public class SafetyComplianceTolerancesMessageConsumer
implements MessageConsumer {
    private final SafetySettingsLookupService safetyLookupService;

    @Inject
    private SafetyComplianceTolerancesMessageConsumer(SafetySettingsLookupService safetyLookupService) {
        this.safetyLookupService = safetyLookupService;
    }

    public void initialize(RobotState robotStateToEditHere) {
    }

    public MessageType getPackageType() {
        return MessageType.SAFETY_COMPLIANCE_TOLERANCES_MESSAGE;
    }

    public int consume(DataInput stream, int messageLength) throws IOException {
        SafetyComplianceTolerances st = this.safetyLookupService.getSafetyComplianceTolerances();
        int messageOffset = SafetyComplianceToleranceMessage.parseMessage(st, stream);
        EventNotificationService.notify(SafetyChangeListener.class, (NotificationStrategy)new NotificationStrategy<SafetyChangeListener>(){

            public void notify(SafetyChangeListener listener) {
                listener.safetyTolerancesReceived(SafetyComplianceTolerancesMessageConsumer.this.safetyLookupService.getSafetyComplianceTolerances());
            }
        });
        Log.trace((String)("safety compliance tolerances received from controller: \n" + this.safetyLookupService.getSafetyComplianceTolerances().toString()));
        return messageOffset;
    }
}

