/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.controllerinterface;

import com.ur.log.logentry.robotmessage.RobotConsumerUtil;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageConsumer;
import com.ur.polyscope.controllerinterface.errorcode.ErrorCode;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.errorcodes.ReportDataType;
import java.io.DataInput;
import java.io.IOException;

public class SafetyModeMessageConsumer
implements RobotMessageConsumer {
    private static final int BASE_MESSAGE_LENGTH = 17;

    public boolean sendNotification() {
        return true;
    }

    public int consume(DataInput stream, int messageLength, RobotMessage robotMessage) throws IOException {
        robotMessage.errorCode = ErrorCode.byId((int)stream.readInt());
        robotMessage.errorArgument = stream.readInt();
        robotMessage.safetyMode = SafetyMode.byId((int)stream.readByte());
        ReportDataType dataType = ReportDataType.byId((int)stream.readInt());
        robotMessage.extraData = RobotConsumerUtil.readValueFromStream((ReportDataType)dataType, (DataInput)stream);
        robotMessage.message = SafetyModeMessageConsumer.readMessage(stream, messageLength);
        return 17 + robotMessage.message.getBytes().length;
    }

    private static String readMessage(DataInput input, int messageLength) throws IOException {
        int len = messageLength - 17;
        byte[] data = new byte[len];
        input.readFully(data, 0, len);
        return new String(data);
    }
}

