/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.controllerinterface;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.MessageConsumer;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.controllerinterface.SafetySetupMessage;
import com.ur.util.logging.Log;
import com.ur.view.constants.comm.MessageType;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Provider;

public class SafetySetupBroadcastMessageConsumer
implements MessageConsumer {
    private final SafetySettingsLookupService safetySettingsLookupService;
    private final Provider<SafetySetupMessage> safetySetupMessageProvider;

    @Inject
    private SafetySetupBroadcastMessageConsumer(SafetySettingsLookupService lookupService, Provider<SafetySetupMessage> safetySetupMessageProvider) {
        this.safetySettingsLookupService = lookupService;
        this.safetySetupMessageProvider = safetySetupMessageProvider;
    }

    public void initialize(RobotState robotStateToEditHere) {
    }

    public MessageType getPackageType() {
        return MessageType.SAFETY_SETUP_BROADCAST_MESSAGE;
    }

    public int consume(DataInput stream, int messageLength) throws IOException {
        SafetySetupMessage ssm = (SafetySetupMessage)this.safetySetupMessageProvider.get();
        int messageOffset = ssm.parseMessage(stream);
        if (ssm.getResult() == null) {
            int bytesLeft = messageLength - messageOffset;
            stream.skipBytes(bytesLeft);
            return messageLength;
        }
        this.setSafetySetup(ssm);
        this.logSafetyReceived(ssm);
        return messageOffset;
    }

    private void setSafetySetup(SafetySetupMessage ssm) {
        if (ssm.getResult() != null) {
            this.safetySettingsLookupService.getCaretaker().setSafetySetupFromController(ssm.getResult());
        } else {
            Log.warning((String)"Received an invalid safety setup message");
        }
    }

    private void logSafetyReceived(SafetySetupMessage ssm) {
        if (Log.canLog((Log.Level)Log.Level.TRACE)) {
            Log.trace((String)("safety setup received from controller: \n" + ssm.getResult().writeAsString()));
        }
    }
}

