/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.controllerinterface;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.SafetySetupComponent;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.controllerinterface.CountingDataInput;
import com.ur.safety.controllerinterface.SafetyConfigurationParser;
import com.ur.safety.controllerinterface.SafetyConfigurationParsers;
import com.ur.safety.version.SafetyVersionValidator;
import com.ur.util.logging.Log;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Provider;

public class SafetySetupMessage {
    private final SafetySettingsLookupService lookupService;
    private final Provider<SafetySetup> safetySetupProvider;
    private final SafetyVersionValidator safetyVersionValidator;
    private final SafetyConfigurationParsers safetyConfigurationParsers;
    private SafetySetup safetySetup;

    @Inject
    protected SafetySetupMessage(SafetySettingsLookupService lookupService, Provider<SafetySetup> safetySetupProvider, SafetyVersionValidator safetyVersionValidator, SafetyConfigurationParsers safetyConfigurationParsers) {
        this.lookupService = lookupService;
        this.safetySetupProvider = safetySetupProvider;
        this.safetyVersionValidator = safetyVersionValidator;
        this.safetyConfigurationParsers = safetyConfigurationParsers;
    }

    public SafetySetup getResult() {
        return this.safetySetup;
    }

    public int parseMessage(DataInput originalStream) throws IOException {
        this.safetySetup = (SafetySetup)this.safetySetupProvider.get();
        ChecksumVersion checksumVersion = this.lookupService.getSafetyComponent(VersionComponent.class).getChecksumVersion();
        ((VersionComponent)this.safetySetup.getComponent(VersionComponent.class)).setChecksumVersion(checksumVersion);
        CountingDataInput stream = new CountingDataInput(originalStream);
        if (!stream.readBoolean()) {
            Log.warning((String)"SAFETY_SETUP: URControl did not generate a valid message");
            this.safetySetup = null;
            return stream.getBytesRead();
        }
        if (!this.safetyVersionValidator.isValidSafetyVersion(stream, checksumVersion)) {
            this.safetySetup = null;
            return stream.getBytesRead();
        }
        for (SafetyConfigurationParser each : this.safetyConfigurationParsers) {
            each.parse(stream, checksumVersion);
        }
        for (SafetyConfigurationParser each : this.safetyConfigurationParsers) {
            if (!each.isActive()) continue;
            this.setComponent(this.safetySetup, each);
        }
        return stream.getBytesRead();
    }

    private <T extends SafetySetupComponent> void setComponent(SafetySetup safetySetup, SafetyConfigurationParser<T> each) {
        safetySetup.setComponent(each.getType(), each.getResult());
    }
}

