/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.controllerinterface;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageConsumer;
import com.ur.polyscope.safety.version.SafetyControlBoardVersionSite;
import com.ur.polyscope.version.urversion.URVersion;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;

public class SafetyVersionMessageConsumer
implements RobotMessageConsumer {
    private static final int BASE_MESSAGE_LENGTH = 9;
    private final SafetyControlBoardVersionSite site;

    @Inject
    private SafetyVersionMessageConsumer(SafetyControlBoardVersionSite site) {
        this.site = site;
    }

    public boolean sendNotification() {
        return true;
    }

    public int consume(DataInput stream, int messageLength, RobotMessage robotMessage) throws IOException {
        int safetyARevision = stream.readInt();
        int safetyBRevision = stream.readInt();
        boolean supportsThreePositionSwitch = stream.readByte() > 0;
        URVersion safetyAVersion = this.buildVersion(safetyARevision);
        URVersion safetyBVersion = this.buildVersion(safetyBRevision);
        robotMessage.message = String.valueOf(safetyAVersion.toString()) + ": " + safetyBVersion.toString();
        this.site.setSafetyControlBoardVersions(safetyAVersion, safetyBVersion, supportsThreePositionSwitch);
        return 9;
    }

    protected URVersion buildVersion(int revisionFromScb) {
        int patchVersion;
        int majorVersion = 0;
        int minorVersion = 0;
        if (revisionFromScb < 10000) {
            patchVersion = revisionFromScb;
        } else {
            majorVersion = revisionFromScb / 10000;
            minorVersion = (revisionFromScb - majorVersion * 10000) / 100;
            patchVersion = revisionFromScb % 100;
        }
        return new URVersion(majorVersion, minorVersion, patchVersion);
    }
}

