/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.controllerinterface.impl;

import com.ur.polyscope.controllerinterface.synchroneous.HMCInterface;
import com.ur.polyscope.controllerinterface.synchroneous.HMCResponse;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.controllerinterface.SafetyRequestFromController;
import com.ur.safety.controllerinterface.SafetySetupMessage;
import com.ur.util.logging.Log;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.inject.Inject;
import javax.inject.Provider;

public class SafetyRequestFromControllerImpl
implements SafetyRequestFromController {
    private final SafetySettingsLookupService safetySettingsLookupService;
    private final Provider<SafetySetupMessage> safetySetupMessageProvider;
    private final HMCInterface hmcInterface;

    @Inject
    private SafetyRequestFromControllerImpl(SafetySettingsLookupService safetySettingsLookupService, Provider<SafetySetupMessage> safetySetupMessageProvider, HMCInterface hmcInterface) {
        this.safetySettingsLookupService = safetySettingsLookupService;
        this.safetySetupMessageProvider = safetySetupMessageProvider;
        this.hmcInterface = hmcInterface;
    }

    @Override
    public boolean requestSafetySetup() {
        SafetySetupMessage ssm;
        block6: {
            DataInputStream dis;
            block5: {
                try {
                    dis = this.createDataInputStream(this.hmcInterface.sendHMCMessageAndWait("request_safety_setup()"));
                    ssm = (SafetySetupMessage)this.safetySetupMessageProvider.get();
                    if (dis != null) break block5;
                    return false;
                }
                catch (Exception e) {
                    Log.error((String)"HMC.requestSafetySetup: Parse error (or similar) ", (Throwable)e);
                    return false;
                }
            }
            ssm.parseMessage(dis);
            if (ssm.getResult() != null) break block6;
            return false;
        }
        this.safetySettingsLookupService.getCaretaker().setSafetySetupFromController(ssm.getResult());
        if (Log.canLog((Log.Level)Log.Level.TRACE)) {
            Log.trace((String)("HMC.requestSafetySetup: Safety setup received from controller: \n" + ssm.getResult().writeAsString()));
        }
        return true;
    }

    private DataInputStream createDataInputStream(HMCResponse m) {
        if (m != null) {
            if (m.getResponseData() == null) {
                Log.error((String)"HMC Message buffer is null!?");
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(m.getResponseData());
            return new DataInputStream(bais);
        }
        Log.error((String)"HMC Response Message is null!?");
        return null;
    }
}

