/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.dashboardservercontributions;

import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.viewfacade.lang.LoadFileCompleted;
import com.ur.safety.SafetyChangeListener;
import com.ur.util.Waiting;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class FileUpdatedOnControllerVerifier
extends SafetyChangeListener.Template
implements LoadFileCompleted,
Waiting.ItHappens {
    private final EventManager eventManager;
    private boolean controllerUpdatedSuccessfully = false;
    private Subscription subscription;
    private ControllerInterface controllerInterface;

    @Inject
    FileUpdatedOnControllerVerifier(EventManager eventManager, ControllerInterface controllerInterface) {
        this.eventManager = eventManager;
        this.controllerInterface = controllerInterface;
    }

    public boolean itHappened() {
        return this.controllerUpdatedSuccessfully;
    }

    @Override
    public void safetyOnControllerUpdated(SafetySetup setup, SafetySetup previousSafety) {
        this.controllerUpdatedSuccessfully = true;
    }

    public void preparingToLoad(String fileName) {
        this.subscription = this.eventManager.addStrongListener(SafetyChangeListener.class, (Object)this);
        this.controllerUpdatedSuccessfully = false;
    }

    public void completed() throws Exception {
        if (!this.controllerInterface.isConnected()) {
            return;
        }
        if (!Waiting.until((Waiting.ItHappens)this, (int)45, (TimeUnit)TimeUnit.SECONDS)) {
            throw new Exception("Safety validation from controller failed: Did not get 'safetyOnControllerUpdated' event");
        }
    }

    public void dispose() {
        this.subscription.dispose();
    }
}

