/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.dashboardservercontributions;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.polyscope.controllerinterface.errorcode.ErrorCode;
import com.ur.safety.ControllerSocketSender;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.dev.SafetyMode;
import gui.tools.DialogCreator;
import javax.inject.Inject;

public class UnlockSafetyAction
extends DashBoardAction.Base
implements RobotMessageListener {
    private static final int WAITING_TIME_SECONDS = 5;
    private static final String CAN_NOT_UNLOCK_PROTECTIVE_STOP = "Cannot unlock protective stop until 5s after occurrence. Always inspect cause of protective stop before unlocking";
    private static final String PROTECTIVE_STOP_RELEASING = "Protective stop releasing";
    private long lastProtectiveStop = -1L;
    private DialogCreator dialogCreator;

    @Inject
    public UnlockSafetyAction(DialogCreator dialogCreator) {
        super("unlock protective stop");
        this.dialogCreator = dialogCreator;
        EventNotificationService.register((Object)((Object)this), RobotMessageListener.class, (Object)((Object)this));
    }

    public String execute(String input) {
        if (this.allowedToUnlock()) {
            return this.unlock();
        }
        return this.unlockDenied();
    }

    protected String unlock() {
        this.dialogCreator.closeSafetyModeDialog(SafetyMode.PROTECTIVE_STOP);
        ControllerSocketSender.sendUnlockProtectiveStop();
        return PROTECTIVE_STOP_RELEASING;
    }

    protected String unlockDenied() {
        return CAN_NOT_UNLOCK_PROTECTIVE_STOP;
    }

    private boolean allowedToUnlock() {
        return this.allowedToUnlock(System.currentTimeMillis(), this.lastProtectiveStop);
    }

    protected boolean allowedToUnlock(long now, long timeOfProtectiveStop) {
        return now > timeOfProtectiveStop + 5000L;
    }

    public void handleRobotMessage(RobotMessage message) {
        if (message.errorCode == ErrorCode.TOO_FREQUENT_PROTECTIVE_STOPS) {
            this.lastProtectiveStop = System.currentTimeMillis();
        }
    }
}

