/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.core;

import com.ur.bean.PropertyChangeSite;
import com.ur.bean.URPropertyChangeSupport;
import com.ur.lang.EqualsBuilder;
import com.ur.lang.HashCodeBuilder;
import com.ur.math.Force;
import com.ur.math.Length;
import com.ur.math.Momentum;
import com.ur.math.NumberValue;
import com.ur.math.Power;
import com.ur.math.Revolution;
import com.ur.math.Speed;
import com.ur.math.Time;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.safety.generallimits.core.Limit;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.util.domain.Q;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class SafetyLimits
implements PropertyChangeSite {
    public static final double FORCE_MAXIMUM = 250.0;
    public static final double POWER_MINIMUM = 80.0;
    public static final double POWER_MAXIMUM = 1000.0;
    public static final double TOOL_SPEED_MAXIMUM = 5.0;
    public static final double TOOL_SPEED_MINIMUM = 0.16;
    public static final double MOMENTUM_MAXIMUM = 100.0;
    public static final double MOMENTUM_MINIMUM = 4.0;
    public static final double MIN_JOINT_SPEED = Math.toRadians(15.0);
    public static final double MIN_JOINT_RANGE_INTERVAL_SIZE = Math.toRadians(7.0);
    private double[] maxJointSpeed = new double[6];
    private Q minJointPosition = new Q();
    private Q maxJointPosition = new Q();
    private final transient URPropertyChangeSupport changeSupport;
    private final transient SafetyLimitsComponent component;

    SafetyLimits(SafetyLimitsComponent component) {
        this.component = component;
        this.changeSupport = new URPropertyChangeSupport((Object)this);
    }

    void initJointsLimitsToDefaultValues(JointConfigurationSettings configuration) {
        this.maxJointSpeed = configuration.getJointMaxSpeed();
        this.minJointPosition = new Q(configuration.getJointMinLimit());
        this.maxJointPosition = new Q(configuration.getJointMaxLimit());
        if (configuration.infiniteRevolutionsForWrist3()) {
            this.maxJointPosition.setJoint(JointType.WRIST3, new Revolution(Integer.MAX_VALUE, 0.0));
            this.minJointPosition.setJoint(JointType.WRIST3, new Revolution(Integer.MIN_VALUE, 0.0));
        }
    }

    public double getMaxPower() {
        return this.currentModeValue(this.component.getMaximumPower()).getIn(Power.Unit.SI);
    }

    public void setMaxPower(double newValue) {
        double oldValue = this.getMaxPower();
        Power otherLimitValue = this.otherModeValue(this.component.getMaximumPower());
        this.component.setMaximumPower(this.createLimit(Power.from((double)newValue, (Power.Unit)Power.Unit.SI), otherLimitValue));
        this.fireEvent(new PropertyChangeEvent(this, "maxPower", oldValue, newValue));
    }

    public double getMaxMomentum() {
        return this.currentModeValue(this.component.getMaximumMomentum()).asFloat();
    }

    public void setMaxMomentum(double maxMomentum) {
        double oldValue = this.getMaxMomentum();
        Momentum otherLimitvalue = this.otherModeValue(this.component.getMaximumMomentum());
        this.component.setMaximumMomentum(this.createLimit(Momentum.create((double)maxMomentum, (Momentum.Unit)Momentum.Unit.SI), otherLimitvalue));
        this.fireEvent(new PropertyChangeEvent(this, "maxMomentum", oldValue, maxMomentum));
    }

    public double getMaxToolSpeed() {
        return this.currentModeValue(this.component.getMaximumToolSpeed()).getIn(Speed.Unit.SI);
    }

    public void setMaxToolSpeed(double newValue) {
        double oldValue = this.getMaxToolSpeed();
        Speed otherLimitValue = this.otherModeValue(this.component.getMaximumToolSpeed());
        this.component.setMaximumToolSpeed(this.createLimit(Speed.from((double)newValue, (Speed.Unit)Speed.Unit.SI), otherLimitValue));
        this.fireEvent(new PropertyChangeEvent(this, "maxTcpSpeed", oldValue, newValue));
    }

    public double getMaxToolForce() {
        return this.currentModeValue(this.component.getMaximumToolForce()).getIn(Force.Unit.SI);
    }

    public void setMaxToolForce(double maxForce) {
        double oldValue = this.getMaxToolForce();
        Force otherLimitValue = this.otherModeValue(this.component.getMaximumToolForce());
        this.component.setMaximumToolForce(this.createLimit(Force.from((double)maxForce, (Force.Unit)Force.Unit.SI), otherLimitValue));
        this.fireEvent(new PropertyChangeEvent(this, "maxForce", oldValue, maxForce));
    }

    public double getMaxElbowSpeed() {
        return this.currentModeValue(this.component.getMaximumElbowSpeed()).getIn(Speed.Unit.SI);
    }

    public void setMaxElbowSpeed(double maxElbowSpeed) {
        double oldValue = this.getMaxElbowSpeed();
        Speed otherLimitValue = this.otherModeValue(this.component.getMaximumElbowSpeed());
        this.component.setMaximumElbowSpeed(this.createLimit(Speed.from((double)maxElbowSpeed, (Speed.Unit)Speed.Unit.SI), otherLimitValue));
        this.fireEvent(new PropertyChangeEvent(this, "maxElbowSpeed", oldValue, maxElbowSpeed));
    }

    public double getMaxElbowForce() {
        return this.currentModeValue(this.component.getMaximumElbowForce()).getIn(Force.Unit.SI);
    }

    public void setMaxElbowForce(double maxElbowForce) {
        double oldValue = this.getMaxElbowForce();
        Force otherLimitValue = this.otherModeValue(this.component.getMaximumElbowForce());
        this.component.setMaximumElbowForce(this.createLimit(Force.from((double)maxElbowForce, (Force.Unit)Force.Unit.SI), otherLimitValue));
        this.fireEvent(new PropertyChangeEvent(this, "maxElbowForce", oldValue, maxElbowForce));
    }

    public double getMaxStoppingDistance() {
        return this.currentModeValue(this.component.getMaximumStoppingDistance()).getIn(Length.Unit.SI);
    }

    public void setMaxStoppingDistance(double maxStoppingDistance) {
        double oldValue = this.getMaxStoppingDistance();
        Length otherLimitValue = this.otherModeValue(this.component.getMaximumStoppingDistance());
        this.component.setMaximumStoppingDistance(this.createLimit(Length.from((double)maxStoppingDistance, (Length.Unit)Length.Unit.SI), otherLimitValue));
        this.fireEvent(new PropertyChangeEvent(this, "maxStoppingDistance", oldValue, maxStoppingDistance));
    }

    public double getMaxStoppingTime() {
        return this.currentModeValue(this.component.getMaximumStoppingTime()).getIn(Time.Unit.SI);
    }

    public void setMaxStoppingTime(double maxStoppingTime) {
        double oldValue = this.getMaxStoppingTime();
        Time otherLimitValue = this.otherModeValue(this.component.getMaximumStoppingTime());
        this.component.setMaximumStoppingTime(this.createLimit(Time.from((double)maxStoppingTime, (Time.Unit)Time.Unit.SI), otherLimitValue));
        this.fireEvent(new PropertyChangeEvent(this, "maxStoppingTime", oldValue, maxStoppingTime));
    }

    public double[] getMaxJointSpeeds() {
        return this.maxJointSpeed;
    }

    public Q getMinJointVector() {
        return this.minJointPosition;
    }

    public Revolution getMinJointPosition(JointType jointType) {
        return this.minJointPosition.getJoint(jointType);
    }

    public Q getMaxJointVector() {
        return this.maxJointPosition;
    }

    public Revolution getMaxJointPosition(JointType jointType) {
        return this.maxJointPosition.getJoint(jointType);
    }

    public void setMaxJointSpeed(double[] maxJointSpeed) {
        double[] oldValues = this.maxJointSpeed;
        this.maxJointSpeed = maxJointSpeed;
        this.fireEvent(new PropertyChangeEvent(this, "maxJointSpeed", oldValues, maxJointSpeed));
    }

    public void setMinJointPosition(JointType jointType, Revolution newValue) {
        Revolution oldValue = this.minJointPosition.getJoint(jointType);
        this.minJointPosition.setJoint(jointType, newValue);
        this.fireEvent(new PropertyChangeEvent(jointType, "minJointPosition", oldValue, newValue));
    }

    public void setMaxJointPosition(JointType jointType, Revolution newValue) {
        Revolution oldValue = this.maxJointPosition.getJoint(jointType);
        this.maxJointPosition.setJoint(jointType, newValue);
        this.fireEvent(new PropertyChangeEvent(jointType, "maxJointPosition", oldValue, newValue));
    }

    public double getMinimumForce(RobotConfigurationProvider robot) {
        return robot.getRobotTool().getMinimumForceValue();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void fireEvent(PropertyChangeEvent evt) {
        this.changeSupport.firePropertyChange(evt);
    }

    public int hashCode() {
        return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).reflectHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return new EqualsBuilder(1.0E-5).isEquals((Object)this, obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    protected abstract <T extends NumberValue> T currentModeValue(Limit<T> var1);

    protected abstract <T extends NumberValue> T otherModeValue(Limit<T> var1);

    protected abstract <T extends NumberValue> Limit<T> createLimit(T var1, T var2);

    static class NormalSafetyLimits
    extends SafetyLimits {
        public NormalSafetyLimits(SafetyLimitsComponent component) {
            super(component);
        }

        @Override
        protected <T extends NumberValue> T currentModeValue(Limit<T> limitValue) {
            return limitValue.getNormalValue();
        }

        @Override
        protected <T extends NumberValue> T otherModeValue(Limit<T> limitValue) {
            return limitValue.getReducedValue();
        }

        @Override
        protected <T extends NumberValue> Limit<T> createLimit(T thisLimit, T otherLimit) {
            return new Limit<T>(thisLimit, otherLimit);
        }
    }

    static class ReducedSafetyLimits
    extends SafetyLimits {
        public ReducedSafetyLimits(SafetyLimitsComponent component) {
            super(component);
        }

        @Override
        protected <T extends NumberValue> T currentModeValue(Limit<T> limitValue) {
            return limitValue.getReducedValue();
        }

        @Override
        protected <T extends NumberValue> T otherModeValue(Limit<T> limitValue) {
            return limitValue.getNormalValue();
        }

        @Override
        protected <T extends NumberValue> Limit<T> createLimit(T thisLimit, T otherLimit) {
            return new Limit<T>(otherLimit, thisLimit);
        }
    }
}

