/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.core;

import com.ur.bean.URPropertyChangeSupport;
import com.ur.lang.Defense;
import com.ur.lang.EqualsBuilder;
import com.ur.lang.HashCodeBuilder;
import com.ur.math.Force;
import com.ur.math.Length;
import com.ur.math.Momentum;
import com.ur.math.Power;
import com.ur.math.Speed;
import com.ur.math.Time;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.safety.SafetySetupComponent;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.safety.generallimits.core.Limit;
import com.ur.safety.generallimits.core.SafetyLimits;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.inject.Inject;

public class SafetyLimitsComponent
implements SafetySetupComponent {
    private final transient URPropertyChangeSupport changeSupport;
    private final SafetyLimits normalLimits;
    private final SafetyLimits reducedLimits;
    private Limit<Power> maximumPower;
    private Limit<Momentum> maximumMomentum;
    private Limit<Length> maximumStoppingDistance;
    private Limit<Time> maximumStoppingTime;
    private Limit<Speed> maximumToolSpeed;
    private Limit<Force> maximumToolForce;
    private Limit<Speed> maximumElbowSpeed;
    private Limit<Force> maximumElbowForce;
    private transient boolean[] withPositionLimits = new boolean[]{true, true, true, true, true, true};

    @Inject
    public SafetyLimitsComponent() {
        this.changeSupport = new URPropertyChangeSupport((Object)this);
        this.maximumPower = new Limit<Power>(Power.ZERO, Power.ZERO);
        this.maximumMomentum = new Limit<Momentum>(Momentum.ZERO, Momentum.ZERO);
        this.maximumStoppingDistance = new Limit<Length>(Length.ZERO, Length.ZERO);
        this.maximumStoppingTime = new Limit<Time>(Time.ZERO, Time.ZERO);
        this.maximumToolSpeed = new Limit<Speed>(Speed.ZERO, Speed.ZERO);
        this.maximumToolForce = new Limit<Force>(Force.ZERO, Force.ZERO);
        this.maximumElbowSpeed = new Limit<Speed>(Speed.ZERO, Speed.ZERO);
        this.maximumElbowForce = new Limit<Force>(Force.ZERO, Force.ZERO);
        this.normalLimits = new SafetyLimits.NormalSafetyLimits(this);
        this.reducedLimits = new SafetyLimits.ReducedSafetyLimits(this);
    }

    public void initJointsLimitstoDefaultValues(JointConfigurationSettings settings) {
        this.normalLimits.initJointsLimitsToDefaultValues(settings);
        this.reducedLimits.initJointsLimitsToDefaultValues(settings);
        this.setWithPositionLimits(JointType.WRIST3, !settings.infiniteRevolutionsForWrist3());
    }

    public Limit<Power> getMaximumPower() {
        return this.maximumPower;
    }

    public void setMaximumPower(Limit<Power> newLimit) {
        this.maximumPower = this.changeValue("maximumPower", this.maximumPower, newLimit);
    }

    public Limit<Momentum> getMaximumMomentum() {
        return this.maximumMomentum;
    }

    public void setMaximumMomentum(Limit<Momentum> newLimit) {
        this.maximumMomentum = this.changeValue("maximumMomentum", this.maximumMomentum, newLimit);
    }

    public Limit<Length> getMaximumStoppingDistance() {
        return this.maximumStoppingDistance;
    }

    public void setMaximumStoppingDistance(Limit<Length> newLimit) {
        this.maximumStoppingDistance = this.changeValue("maximumStoppingDistance", this.maximumStoppingDistance, newLimit);
    }

    public Limit<Time> getMaximumStoppingTime() {
        return this.maximumStoppingTime;
    }

    public void setMaximumStoppingTime(Limit<Time> newLimit) {
        this.maximumStoppingTime = this.changeValue("maximumStoppingTime", this.maximumStoppingTime, newLimit);
    }

    public Limit<Speed> getMaximumToolSpeed() {
        return this.maximumToolSpeed;
    }

    public void setMaximumToolSpeed(Limit<Speed> newLimit) {
        this.maximumToolSpeed = this.changeValue("maximumToolSpeed", this.maximumToolSpeed, newLimit);
    }

    public Limit<Force> getMaximumToolForce() {
        return this.maximumToolForce;
    }

    public void setMaximumToolForce(Limit<Force> newLimit) {
        this.maximumToolForce = this.changeValue("maximumToolForce", this.maximumToolForce, newLimit);
    }

    public Limit<Speed> getMaximumElbowSpeed() {
        return this.maximumElbowSpeed;
    }

    public void setMaximumElbowSpeed(Limit<Speed> newLimit) {
        this.maximumElbowSpeed = this.changeValue("maximumElbowSpeed", this.maximumElbowSpeed, newLimit);
    }

    public Limit<Force> getMaximumElbowForce() {
        return this.maximumElbowForce;
    }

    public void setMaximumElbowForce(Limit<Force> newLimit) {
        this.maximumElbowForce = this.changeValue("maximumElbowForce", this.maximumElbowForce, newLimit);
    }

    public boolean getWithPositionLimits(JointType jointType) {
        return this.withPositionLimits[jointType.getJointNumber()];
    }

    public boolean[] getWithPositionLimits() {
        return (boolean[])this.withPositionLimits.clone();
    }

    public void setWithPositionLimits(boolean[] newLimits) {
        this.withPositionLimits = this.changeValue("withPositionLimits", this.withPositionLimits, (boolean[])newLimits.clone());
    }

    public void setWithPositionLimits(JointType jointType, boolean withPositionLimits) {
        boolean[] oldValues = this.withPositionLimits;
        this.withPositionLimits[jointType.getJointNumber()] = withPositionLimits;
        this.changeSupport.firePropertyChange(new PropertyChangeEvent(this, "withPositionLimits", oldValues, withPositionLimits));
    }

    private <T> T changeValue(String methodName, T oldLimit, T newLimit) {
        Defense.notNull(newLimit);
        this.changeSupport.firePropertyChange(new PropertyChangeEvent(this, methodName, oldLimit, newLimit));
        return newLimit;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
        this.normalLimits.addPropertyChangeListener(listener);
        this.reducedLimits.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
        this.normalLimits.removePropertyChangeListener(listener);
        this.reducedLimits.removePropertyChangeListener(listener);
    }

    public int hashCode() {
        return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).reflectHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return new EqualsBuilder(1.0E-5).isEquals((Object)this, obj);
    }

    public boolean completelyEquals(Object other) {
        if (other == null || SafetyLimitsComponent.class != other.getClass()) {
            return false;
        }
        SafetyLimitsComponent otherComponent = (SafetyLimitsComponent)other;
        return this.normalLimits.equals(otherComponent.normalLimits) && this.reducedLimits.equals(otherComponent.reducedLimits);
    }

    public boolean isReducedModeDefined() {
        return false;
    }

    public SafetyLimits getNormalLimits() {
        return this.normalLimits;
    }

    public double getMaximumCombinedJointLimit(JointType jointType) {
        if (this.getWithPositionLimits(jointType)) {
            double normalModeValue = this.getNormalLimits().getMaxJointPosition(jointType).getTotalAngle();
            double reducedModeValue = this.getReducedLimits().getMaxJointPosition(jointType).getTotalAngle();
            return this.getMaximum(normalModeValue, reducedModeValue);
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getMinimumCombinedJointLimit(JointType jointType) {
        if (this.getWithPositionLimits(jointType)) {
            double normalModeValue = this.getNormalLimits().getMinJointPosition(jointType).getTotalAngle();
            double reducedModeValue = this.getReducedLimits().getMinJointPosition(jointType).getTotalAngle();
            return this.getMinimum(normalModeValue, reducedModeValue);
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getMaximumJointLimit(JointType jointType, boolean reducedMode) {
        if (this.getWithPositionLimits(jointType)) {
            return this.getSafetyLimits(reducedMode).getMaxJointPosition(jointType).getTotalAngle();
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getMinimumJointLimit(JointType jointType, boolean reducedMode) {
        if (this.getWithPositionLimits(jointType)) {
            return this.getSafetyLimits(reducedMode).getMinJointPosition(jointType).getTotalAngle();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public SafetyLimits getSafetyLimits(boolean reducedMode) {
        return reducedMode ? this.getReducedLimits() : this.getNormalLimits();
    }

    private double getMinimum(double normalModeValue, double reducedModeValue) {
        if (this.isReducedModeDefined()) {
            return Math.min(normalModeValue, reducedModeValue);
        }
        return normalModeValue;
    }

    private double getMaximum(double normalModeValue, double reducedModeValue) {
        if (this.isReducedModeDefined()) {
            return Math.max(normalModeValue, reducedModeValue);
        }
        return normalModeValue;
    }

    public boolean isJointInsideCombinedSafetyLimit(JointType jointType, double angle) {
        double jointMaxLimit = this.getMaximumCombinedJointLimit(jointType);
        double jointMinLimit = this.getMinimumCombinedJointLimit(jointType);
        return jointMinLimit < angle && angle < jointMaxLimit;
    }

    public SafetyLimits getReducedLimits() {
        return this.reducedLimits;
    }
}

