/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.domain;

import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.generallimits.domain.GeneralLimitsPersistence;
import com.ur.safety.generallimits.domain.SafetyLimitsContribution;

public class GeneralLimitsPersistenceImpl
implements GeneralLimitsPersistence {
    @Override
    public void readFromOptions(SafetyLimits limits, String mode, Options options) {
        OptionsSection values = options.getSection("SafetyLimits " + mode + " Values");
        limits.setMaxToolSpeed(values.getDouble("maxTcpSpeed", Double.valueOf(limits.getMaxToolSpeed())));
        limits.setMaxToolForce(values.getDouble("maxForce", Double.valueOf(limits.getMaxToolForce())));
        limits.setMaxElbowSpeed(values.getDouble("maxElbowSpeed", Double.valueOf(limits.getMaxElbowSpeed())));
        limits.setMaxElbowForce(values.getDouble("maxElbowForce", Double.valueOf(limits.getMaxElbowForce())));
        limits.setMaxStoppingDistance(values.getDouble("maxStoppingDistance", Double.valueOf(limits.getMaxStoppingDistance())));
        limits.setMaxStoppingTime(values.getDouble("maxStoppingTime", Double.valueOf(limits.getMaxStoppingTime())));
        limits.setMaxPower(values.getDouble("maxPower", Double.valueOf(limits.getMaxPower())));
        limits.setMaxMomentum(values.getDouble("maxMomentum", Double.valueOf(limits.getMaxMomentum())));
    }

    @Override
    public void copyToOptionsFromSection(SafetyLimits limits, String mode, Options options) {
        OptionsSection values = options.getSection("SafetyLimits " + mode + " Values");
        values.setDouble("maxTcpSpeed", Double.valueOf(limits.getMaxToolSpeed()));
        values.setDouble("maxForce", Double.valueOf(limits.getMaxToolForce()));
        values.setDouble("maxElbowSpeed", Double.valueOf(limits.getMaxElbowSpeed()));
        values.setDouble("maxElbowForce", Double.valueOf(limits.getMaxElbowForce()));
        values.setDouble("maxStoppingDistance", Double.valueOf(limits.getMaxStoppingDistance()));
        values.setDouble("maxStoppingTime", Double.valueOf(limits.getMaxStoppingTime()));
        values.setDouble("maxPower", Double.valueOf(limits.getMaxPower()));
        values.setDouble("maxMomentum", Double.valueOf(limits.getMaxMomentum()));
    }

    @Override
    public void copyControllerRepresentationFromSectionTo(SafetyLimitsComponent component, SafetyLimitsContribution.FromLimit limits, OptionsSection section) {
        section.setFloat("maxTcpSpeed", Float.valueOf(limits.getValue(component.getMaximumToolSpeed())));
        section.setFloat("maxForce", Float.valueOf(limits.getValue(component.getMaximumToolForce())));
        section.setFloat("maxElbowSpeed", Float.valueOf(limits.getValue(component.getMaximumElbowSpeed())));
        section.setFloat("maxElbowForce", Float.valueOf(limits.getValue(component.getMaximumElbowForce())));
        section.setFloat("maxStoppingDistance", Float.valueOf(limits.getValue(component.getMaximumStoppingDistance())));
        section.setFloat("maxStoppingTime", Float.valueOf(limits.getValue(component.getMaximumStoppingTime())));
        section.setFloat("maxPower", Float.valueOf(limits.getValue(component.getMaximumPower())));
        section.setFloat("maxMomentum", Float.valueOf(limits.getValue(component.getMaximumMomentum())));
    }
}

