/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.domain;

import com.ur.lang.EndianConverter;
import com.ur.monitor.model.JointType;
import com.ur.safety.generallimits.domain.ModeLimitsParser;
import java.io.DataInput;
import java.io.IOException;

public abstract class GeneralModeLimitsParser
implements ModeLimitsParser {
    protected final EndianConverter endianConverter;

    public GeneralModeLimitsParser(EndianConverter endianConverter) {
        this.endianConverter = endianConverter;
    }

    @Override
    public double[] parseMaxJointSpeeds(DataInput stream) throws IOException {
        return this.parseJointPositions(stream);
    }

    @Override
    public double[] parseJointPositions(DataInput stream) throws IOException {
        double[] jointPositions = new double[JointType.values().length];
        int i = 0;
        while (i < jointPositions.length) {
            jointPositions[i] = this.endianConverter.convert(stream);
            ++i;
        }
        return jointPositions;
    }

    @Override
    public int[] parseJointRevolutions(DataInput stream) throws IOException {
        int[] jointRevolutions = new int[JointType.values().length];
        int i = 0;
        while (i < jointRevolutions.length) {
            jointRevolutions[i] = this.endianConverter.convert(stream.readInt());
            ++i;
        }
        return jointRevolutions;
    }
}

