/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.domain;

import com.ur.math.NumberValue;
import com.ur.math.Revolution;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.safety.SafetySetupContribution;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.generallimits.core.Limit;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.generallimits.domain.GeneralLimitsMode;
import com.ur.safety.generallimits.domain.GeneralLimitsPersistence;
import com.ur.safety.generallimits.domain.SingleModePattern;
import com.ur.safety.generallimits.service.GeneralLimitsService;
import com.ur.safety.installation.SafetySetupConverter;
import com.ur.view.Settings;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SafetyLimitsContribution
implements SafetySetupContribution<SafetyLimitsComponent>,
SafetySetupConverter<SafetyLimitsComponent> {
    public static final String MAX_TOOL_SPEED_PROPERTY = "maxTcpSpeed";
    public static final String MAX_TOOL_FORCE_PROPERTY = "maxForce";
    public static final String MAX_ELBOW_SPEED_PROPERTY = "maxElbowSpeed";
    public static final String MAX_ELBOW_FORCE_PROPERTY = "maxElbowForce";
    public static final String MAX_STOPPING_DISTANCE_PROPERTY = "maxStoppingDistance";
    public static final String MAX_STOPPING_TIME_PROPERTY = "maxStoppingTime";
    public static final String MAX_POWER_PROPERTY = "maxPower";
    public static final String MAX_MOMENTUM_PROPERTY = "maxMomentum";
    public static final String MAX_JOINT_SPEED = "maxJointSpeed";
    public static final String MIN_JOINT_POSITION = "minJointPosition";
    public static final String MAX_JOINT_POSITION = "maxJointPosition";
    public static final String MIN_JOINT_REVOLUTIONS = "minJointRevolutions";
    public static final String MAX_JOINT_REVOLUTIONS = "maxJointRevolutions";
    private final JointConfigurationSettings jointConfigurationSettings;
    private final GeneralLimitsPersistence generalLimitsPersistence;
    private final GeneralLimitsService generalLimitsService;

    @Inject
    public SafetyLimitsContribution(JointConfigurationSettings jointConfigurationSettings, GeneralLimitsPersistence generalLimitsPersistence, GeneralLimitsService generalLimitsService) {
        this.jointConfigurationSettings = jointConfigurationSettings;
        this.generalLimitsPersistence = generalLimitsPersistence;
        this.generalLimitsService = generalLimitsService;
    }

    @Override
    public Class<SafetyLimitsComponent> getComponentType() {
        return SafetyLimitsComponent.class;
    }

    @Override
    public void convertToG5(SafetyLimitsComponent component) {
        SingleModePattern pattern = this.generalLimitsService.getPattern(GeneralLimitsMode.LEAST_RESTRICTED_MODE);
        pattern.applyG5ChangesTo(component);
    }

    @Override
    public List<String> getAffectedG3SafetyItems(SafetyLimitsComponent safetySetup, SafetyTextResource textResource) {
        return Arrays.asList(textResource.toolSpeed(), textResource.toolForce());
    }

    public SafetyLimitsComponent createDefaultComponent() {
        SafetyLimitsComponent component = new SafetyLimitsComponent();
        this.generalLimitsService.applyPreset(GeneralLimitsMode.DEFAULT_MODE, component);
        component.initJointsLimitstoDefaultValues(this.jointConfigurationSettings);
        return component;
    }

    public SafetyLimitsComponent readFromOptions(ChecksumVersion checksumVersion, Options options) {
        SafetyLimitsComponent component = this.createDefaultComponent();
        this.readFromOptions(component.getNormalLimits(), SafetyLimitMode.NORMAL.getName(), checksumVersion, options);
        this.readFromOptions(component.getReducedLimits(), SafetyLimitMode.REDUCED.getName(), checksumVersion, options);
        component.setWithPositionLimits(options.getSection("SafetySetup").getBooleanArray("withPositionLimits", new boolean[]{true, true, true, true, true, true}));
        return component;
    }

    private void readFromOptions(SafetyLimits limits, String mode, ChecksumVersion checksumVersion, Options options) {
        this.generalLimitsPersistence.readFromOptions(limits, mode, options);
        OptionsSection jointValues = options.getSection("SafetyLimits " + mode + " Joints");
        limits.setMaxJointSpeed(jointValues.getDoubleArray(MAX_JOINT_SPEED, limits.getMaxJointSpeeds()));
        double[] minAngles = jointValues.getDoubleArray(MIN_JOINT_POSITION, limits.getMinJointVector().getAngles());
        double[] maxAngles = jointValues.getDoubleArray(MAX_JOINT_POSITION, limits.getMaxJointVector().getAngles());
        int[] minRevolutions = jointValues.getIntArray(MIN_JOINT_REVOLUTIONS, limits.getMinJointVector().getRevolutions());
        int[] maxRevolutions = jointValues.getIntArray(MAX_JOINT_REVOLUTIONS, limits.getMaxJointVector().getRevolutions());
        JointType[] jointTypeArray = JointType.values();
        int n = jointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JointType jointType = jointTypeArray[n2];
            int jointNo = jointType.getJointNumber();
            if (checksumVersion.atLeast(ChecksumVersion.VERSION_3_1)) {
                limits.setMinJointPosition(jointType, new Revolution(minRevolutions[jointNo], minAngles[jointNo]));
                limits.setMaxJointPosition(jointType, new Revolution(maxRevolutions[jointNo], maxAngles[jointNo]));
            } else {
                limits.setMinJointPosition(jointType, new Revolution(minAngles[jointNo]));
                limits.setMaxJointPosition(jointType, new Revolution(maxAngles[jointNo]));
            }
            ++n2;
        }
    }

    public void copyToOptions(ChecksumVersion checksumVersion, Options options, SafetyLimitsComponent component) {
        this.copyToOptionsFromSection(component.getNormalLimits(), SafetyLimitMode.NORMAL.getName(), options);
        this.copyToOptionsFromSection(component.getReducedLimits(), SafetyLimitMode.REDUCED.getName(), options);
        options.getSection("SafetySetup").setBooleanArray("withPositionLimits", component.getWithPositionLimits());
    }

    private void copyToOptionsFromSection(SafetyLimits limits, String mode, Options options) {
        this.generalLimitsPersistence.copyToOptionsFromSection(limits, mode, options);
        OptionsSection jointValues = options.getSection("SafetyLimits " + mode + " Joints");
        jointValues.setDoubleArray(MAX_JOINT_SPEED, limits.getMaxJointSpeeds());
        jointValues.setDoubleArray(MIN_JOINT_POSITION, limits.getMinJointVector().getAngles());
        jointValues.setDoubleArray(MAX_JOINT_POSITION, limits.getMaxJointVector().getAngles());
        jointValues.setIntArray(MIN_JOINT_REVOLUTIONS, limits.getMinJointVector().getRevolutions());
        jointValues.setIntArray(MAX_JOINT_REVOLUTIONS, limits.getMaxJointVector().getRevolutions());
    }

    public void copyControllerRepresentationTo(ChecksumVersion checksumVersion, Options options, SafetyLimitsComponent component) {
        SafetyLimits limits = component.getNormalLimits();
        OptionsSection section = options.getSection("NormalModeSafetyLimits");
        this.copyControllerRepresentationFromSectionTo(component, new NormalFromLimit(), limits, section);
        limits = component.getReducedLimits();
        section = options.getSection("ReducedModeSafetyLimits");
        this.copyControllerRepresentationFromSectionTo(component, new ReducedFromLimit(), limits, section);
    }

    private void copyControllerRepresentationFromSectionTo(SafetyLimitsComponent component, FromLimit limits, SafetyLimits safetyLimits, OptionsSection section) {
        this.generalLimitsPersistence.copyControllerRepresentationFromSectionTo(component, limits, section);
        float[] maxJointSpeedToController = new float[6];
        int i = 0;
        while (i < maxJointSpeedToController.length) {
            maxJointSpeedToController[i] = (float)safetyLimits.getMaxJointSpeeds()[i];
            ++i;
        }
        JointType[] jointTypeArray = JointType.values();
        int n = jointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JointType jointType = jointTypeArray[n2];
            if (!component.getWithPositionLimits(jointType)) {
                safetyLimits.setMinJointPosition(jointType, new Revolution(Integer.MIN_VALUE, 0.0));
                safetyLimits.setMaxJointPosition(jointType, new Revolution(Integer.MAX_VALUE, 0.0));
            }
            ++n2;
        }
        section.setFloatArray(MAX_JOINT_SPEED, maxJointSpeedToController);
        section.setFloatArray(MIN_JOINT_POSITION, this.toFloat(safetyLimits.getMinJointVector().getAngles()));
        section.setFloatArray(MAX_JOINT_POSITION, this.toFloat(safetyLimits.getMaxJointVector().getAngles()));
        int[] minJointLimits = safetyLimits.getMinJointVector().getRevolutions();
        int[] maxJointLimits = safetyLimits.getMaxJointVector().getRevolutions();
        if (Settings.hasPolyScopeModification((Settings.PolyScopeModification)Settings.PolyScopeModification.SEND_MODIFIED_JOINT_POSITION_LIMITS_FOR_WRIST3_TO_CONTROLLER)) {
            minJointLimits[5] = minJointLimits[5] + 2;
            maxJointLimits[5] = maxJointLimits[5] + 2;
        }
        section.setIntArray(MIN_JOINT_REVOLUTIONS, minJointLimits);
        section.setIntArray(MAX_JOINT_REVOLUTIONS, maxJointLimits);
    }

    public boolean isSupported(ChecksumVersion version) {
        return true;
    }

    private float[] toFloat(double[] d) {
        float[] result = new float[d.length];
        int i = 0;
        while (i < d.length) {
            result[i] = (float)d[i];
            ++i;
        }
        return result;
    }

    public static interface FromLimit {
        public <T extends NumberValue> float getValue(Limit<T> var1);
    }

    private static class NormalFromLimit
    implements FromLimit {
        private NormalFromLimit() {
        }

        @Override
        public <T extends NumberValue> float getValue(Limit<T> limit) {
            return limit.getNormalValue().asFloat();
        }
    }

    private static class ReducedFromLimit
    implements FromLimit {
        private ReducedFromLimit() {
        }

        @Override
        public <T extends NumberValue> float getValue(Limit<T> limit) {
            return limit.getReducedValue().asFloat();
        }
    }
}

