/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.domain;

import com.ur.math.Revolution;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.controllerinterface.SafetyConfigurationParser;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.generallimits.domain.ModeLimitsParser;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;

public class SafetyLimitsParser {
    private final ModeLimitsParser modeLimitsParser;
    private final SafetyLimitsComponent component;

    @Inject
    public SafetyLimitsParser(ModeLimitsParser limitsParser) {
        this.modeLimitsParser = limitsParser;
        this.component = new SafetyLimitsComponent();
    }

    public SafetyConfigurationParser<SafetyLimitsComponent> normalModeGeneralLimitsParser() {
        return new LimitsParserAdapter(this){

            @Override
            public void parse(DataInput stream, ChecksumVersion version) throws IOException {
                this.processGeneralLimits(component.getNormalLimits(), stream);
            }
        };
    }

    public SafetyConfigurationParser<SafetyLimitsComponent> normalModeJointLimitsParser() {
        return new LimitsParserAdapter(this){

            @Override
            public void parse(DataInput stream, ChecksumVersion version) throws IOException {
                this.processJointLimits(component.getNormalLimits(), stream);
            }
        };
    }

    public SafetyConfigurationParser<SafetyLimitsComponent> reducedModeGeneralLimitsParser() {
        return new LimitsParserAdapter(this){

            @Override
            public void parse(DataInput stream, ChecksumVersion version) throws IOException {
                this.processGeneralLimits(component.getReducedLimits(), stream);
            }
        };
    }

    public SafetyConfigurationParser<SafetyLimitsComponent> reducedModeJointLimitsParser() {
        return new LimitsParserAdapter(this){

            @Override
            public void parse(DataInput stream, ChecksumVersion version) throws IOException {
                this.processJointLimits(component.getReducedLimits(), stream);
            }
        };
    }

    private void processGeneralLimits(SafetyLimits safetyLimits, DataInput stream) throws IOException {
        this.modeLimitsParser.parseGeneralLimits(safetyLimits, stream);
    }

    private void processJointLimits(SafetyLimits safetyLimits, DataInput stream) throws IOException {
        safetyLimits.setMaxJointSpeed(this.modeLimitsParser.parseMaxJointSpeeds(stream));
        int[] minJointRevolutionsController = this.modeLimitsParser.parseJointRevolutions(stream);
        double[] minJointPositionsController = this.modeLimitsParser.parseJointPositions(stream);
        int[] maxJointRevolutionsController = this.modeLimitsParser.parseJointRevolutions(stream);
        double[] maxJointPositionsController = this.modeLimitsParser.parseJointPositions(stream);
        JointType[] jointTypeArray = JointType.values();
        int n = jointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JointType jointType = jointTypeArray[n2];
            int jointNo = jointType.getJointNumber();
            Revolution minRevolution = new Revolution(minJointRevolutionsController[jointNo], minJointPositionsController[jointNo]);
            safetyLimits.setMinJointPosition(jointType, minRevolution);
            Revolution maxRevolution = new Revolution(maxJointRevolutionsController[jointNo], maxJointPositionsController[jointNo]);
            safetyLimits.setMaxJointPosition(jointType, maxRevolution);
            ++n2;
        }
    }

    private SafetyLimitsComponent getResult() {
        return this.component;
    }

    private abstract class LimitsParserAdapter
    extends SafetyConfigurationParser.ActiveParserTemplate<SafetyLimitsComponent> {
        private LimitsParserAdapter() {
        }

        @Override
        public Class<SafetyLimitsComponent> getType() {
            return SafetyLimitsComponent.class;
        }

        @Override
        public SafetyLimitsComponent getResult() {
            return SafetyLimitsParser.this.getResult();
        }
    }
}

