/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.domain;

import com.ur.lang.EqualsUtil;
import com.ur.math.Force;
import com.ur.math.Length;
import com.ur.math.Momentum;
import com.ur.math.Power;
import com.ur.math.Speed;
import com.ur.math.Time;
import com.ur.safety.generallimits.core.Limit;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.generallimits.domain.SingleModePattern;

public class SafetyPreset {
    private final Limit<Force> toolForce;
    private final Limit<Power> power;
    private final Limit<Speed> toolSpeed;
    private final Limit<Momentum> momentum;
    private final Limit<Force> elbowForce;
    private final Limit<Speed> elbowSpeed;
    private final Limit<Length> stoppingDistance;
    private final Limit<Time> stoppingTime;

    public SafetyPreset(SingleModePattern normalModePattern, SingleModePattern reducedModePattern) {
        this.toolForce = new Limit<Force>(normalModePattern.getToolForce(), reducedModePattern.getToolForce());
        this.power = new Limit<Power>(normalModePattern.getPower(), reducedModePattern.getPower());
        this.toolSpeed = new Limit<Speed>(normalModePattern.getToolSpeed(), reducedModePattern.getToolSpeed());
        this.momentum = new Limit<Momentum>(normalModePattern.getMomentum(), reducedModePattern.getMomentum());
        this.elbowForce = new Limit<Force>(normalModePattern.getElbowForce(), reducedModePattern.getElbowForce());
        this.elbowSpeed = new Limit<Speed>(normalModePattern.getElbowSpeed(), reducedModePattern.getElbowSpeed());
        this.stoppingDistance = new Limit<Length>(normalModePattern.getStoppingDistance(), reducedModePattern.getStoppingDistance());
        this.stoppingTime = new Limit<Time>(normalModePattern.getStoppingTime(), reducedModePattern.getStoppingTime());
    }

    public void applyTo(SafetyLimitsComponent safetyLimits) {
        safetyLimits.setMaximumToolForce(this.toolForce);
        safetyLimits.setMaximumPower(this.power);
        safetyLimits.setMaximumToolSpeed(this.toolSpeed);
        safetyLimits.setMaximumMomentum(this.momentum);
        safetyLimits.setMaximumElbowForce(this.elbowForce);
        safetyLimits.setMaximumElbowSpeed(this.elbowSpeed);
        safetyLimits.setMaximumStoppingDistance(this.stoppingDistance);
        safetyLimits.setMaximumStoppingTime(this.stoppingTime);
    }

    public boolean isApplied(SafetyLimitsComponent component) {
        return EqualsUtil.equals(component.getMaximumToolForce(), this.toolForce) && EqualsUtil.equals(component.getMaximumPower(), this.power) && EqualsUtil.equals(component.getMaximumToolSpeed(), this.toolSpeed) && EqualsUtil.equals(component.getMaximumMomentum(), this.momentum) && EqualsUtil.equals(component.getMaximumElbowForce(), this.elbowForce) && EqualsUtil.equals(component.getMaximumElbowSpeed(), this.elbowSpeed) && EqualsUtil.equals(component.getMaximumStoppingDistance(), this.stoppingDistance) && EqualsUtil.equals(component.getMaximumStoppingTime(), this.stoppingTime);
    }
}

