/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.domain;

import com.ur.math.Force;
import com.ur.math.Length;
import com.ur.math.Momentum;
import com.ur.math.Power;
import com.ur.math.Speed;
import com.ur.math.Time;
import com.ur.safety.generallimits.core.Limit;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;

public class SingleModePattern {
    private final Force toolForce;
    private final Power power;
    private final Speed toolSpeed;
    private final Momentum momentum;
    private final Force elbowForce;
    private final Speed elbowSpeed;
    private final Length stoppingDistance;
    private final Time stoppingTime;

    public SingleModePattern(Force toolForce, Power power, Speed toolSpeed, Momentum momentum, Force elbowForce, Speed elbowSpeed, Length stoppingDistance, Time stoppingTime) {
        this.toolForce = toolForce;
        this.power = power;
        this.toolSpeed = toolSpeed;
        this.momentum = momentum;
        this.elbowForce = elbowForce;
        this.elbowSpeed = elbowSpeed;
        this.stoppingDistance = stoppingDistance;
        this.stoppingTime = stoppingTime;
    }

    void applyG5ChangesTo(SafetyLimitsComponent component) {
        component.setMaximumElbowForce(new Limit<Force>(this.elbowForce, this.elbowForce));
        component.setMaximumElbowSpeed(new Limit<Speed>(this.elbowSpeed, this.elbowSpeed));
        component.setMaximumStoppingDistance(new Limit<Length>(this.stoppingDistance, this.stoppingDistance));
        component.setMaximumStoppingTime(new Limit<Time>(this.stoppingTime, this.stoppingTime));
    }

    public Force getToolForce() {
        return this.toolForce;
    }

    public Power getPower() {
        return this.power;
    }

    public Speed getToolSpeed() {
        return this.toolSpeed;
    }

    public Momentum getMomentum() {
        return this.momentum;
    }

    public Force getElbowForce() {
        return this.elbowForce;
    }

    public Speed getElbowSpeed() {
        return this.elbowSpeed;
    }

    public Length getStoppingDistance() {
        return this.stoppingDistance;
    }

    public Time getStoppingTime() {
        return this.stoppingTime;
    }
}

