/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.externalapi;

import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotTool;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.Settings;
import com.ur.safety.generallimits.externalapi.GeneralLimitsInputBinder;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import java.text.Format;
import javax.inject.Inject;

public class GeneralLimitsInputBinderImpl
implements GeneralLimitsInputBinder {
    private static final boolean ALLOW = true;
    private static final boolean RESTRICT = false;
    private static final double IMPERIAL_POSITIVE_DECIMAL_CORRECTION = 0.005;
    private static final double IMPERIAL_NEGATIVE_DECIMAL_CORRECTION = 0.002;
    private final double minForceValue;
    private final double maxForceValue;
    private final double minMomentumValue;
    private final double maxMomentumValue;
    private final double minToolSpeedValue;
    private final double maxToolSpeedValue;
    private final double minElbowSpeedValue;
    private final double maxElbowSpeedValue;
    private final double minStoppingTimeValue;
    private final double maxStoppingTimeValue;
    private final SafetyTextResource text;

    @Inject
    public GeneralLimitsInputBinderImpl(SafetyTextResource text, RobotConfigurationProvider robot) {
        this.text = text;
        RobotTool robotTool = robot.getRobotTool();
        this.minForceValue = robotTool.getMinimumForceValue();
        this.maxForceValue = robotTool.getMaximumForceValue();
        this.minMomentumValue = robotTool.getMinimumMomentumValue();
        this.maxMomentumValue = robotTool.getMaximumMomentumValue();
        this.minToolSpeedValue = robotTool.getMinimumToolSpeedValue();
        this.maxToolSpeedValue = robotTool.getMaximumToolSpeedValue();
        this.minElbowSpeedValue = robotTool.getMinimumElbowSpeedValue();
        this.maxElbowSpeedValue = robotTool.getMaximumElbowSpeedValue();
        this.minStoppingTimeValue = robotTool.getMinimumStoppingTimeValue();
        this.maxStoppingTimeValue = robotTool.getMaximumStoppingTimeValue();
    }

    @Override
    public void bindMaxPower(NumberField normal, NumberField reduce) {
        UnitsConverter converter = Units.getWattConverter();
        String limits = this.text.minimumAndMaximumValue(80L, 1000L, converter.getUnit());
        ValidationStrategy strategy = ValidationFactory.getRangeValidator((double)80.0, (double)1000.0, (String)this.text.valueOutsideOfRange());
        normal.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getValueAboveValidationStrategy((NumberField)reduce, (String)this.text.valueMustBeEqualOrAboveReducedValue())});
        reduce.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getValueBelowValidationStrategy((NumberField)normal, (String)this.text.valueMustBeEqualOrBelowNormalValue())});
        this.setRestrictionsText(normal, reduce, limits);
        this.bindPositiveWholeNumberValidation(normal, reduce, strategy, true);
    }

    @Override
    public void bindMaxMomentum(NumberField normal, NumberField reduce) {
        String limits;
        UnitsConverter converter = Units.getKgMsConverter();
        if (Settings.getUnits().isUS()) {
            limits = this.correctForImperialDecimalPlaces(converter, normal, reduce);
        } else {
            limits = this.text.minimumAndMaximumValuesTo1Decimals(converter.convertFrom(this.minMomentumValue), converter.convertFrom(this.maxMomentumValue), converter.getUnit());
            ValidationStrategy strategy = ValidationFactory.getRangeValidator((double)converter.convertFrom(this.minMomentumValue), (double)converter.convertFrom(this.maxMomentumValue), (String)this.text.valueOutsideOfRange());
            this.bindPositiveTo10thDecimalValidation(normal, reduce, strategy, false);
        }
        this.setRestrictionsText(normal, reduce, limits);
    }

    private String correctForImperialDecimalPlaces(UnitsConverter converter, NumberField normal, NumberField reduce) {
        if (this.minMomentumValue <= 0.002) {
            throw new IllegalArgumentException("minMomentvalue should never be below 0.002 as this destroys precision for imperial conversion");
        }
        String limits = this.text.minimumAndMaximumValues(Math.round(converter.convertFrom(this.minMomentumValue - 0.002)), Math.round(converter.convertFrom(this.maxMomentumValue + 0.005)), converter.getUnit());
        ValidationStrategy strategy = ValidationFactory.getRangeValidator((double)Math.round(converter.convertFrom(this.minMomentumValue - 0.002)), (double)Math.round(converter.convertFrom(this.maxMomentumValue + 0.005)), (String)this.text.valueOutsideOfRange());
        this.bindPositiveWholeNumberValidation(normal, reduce, strategy, false);
        return limits;
    }

    @Override
    public void bindMaxStoppingTime(NumberField normal, NumberField reduce) {
        UnitsConverter converter = Units.getTimeConverter();
        String limits = this.text.minimumAndMaximumValue((long)converter.convertFrom(this.minStoppingTimeValue), (long)converter.convertFrom(this.maxStoppingTimeValue), converter.getUnit());
        ValidationStrategy strategy = ValidationFactory.getRangeValidator((double)converter.convertFrom(this.minStoppingTimeValue), (double)converter.convertFrom(this.maxStoppingTimeValue), (String)this.text.valueOutsideOfRange());
        this.setRestrictionsText(normal, reduce, limits);
        this.bindPositiveWholeNumberValidation(normal, reduce, strategy, false);
    }

    @Override
    public void bindMaxStoppingDistance(NumberField normal, NumberField reduce) {
        String limits;
        UnitsConverter converter = Units.getMetersConverter();
        ValidationStrategy strategy = ValidationFactory.getRangeValidator((double)converter.convertFrom(0.05), (double)converter.convertFrom(4.0), (String)this.text.valueOutsideOfRange());
        if (Settings.getUnits().isUS()) {
            this.bindPositiveTo100thDecimalValidation(normal, reduce);
            limits = this.text.minimumAndMaximumValuesTo3Decimals(converter.convertFrom(0.05), converter.convertFrom(4.0), converter.getUnit());
            this.setErrorValidationStrategy(normal, reduce, strategy);
        } else {
            this.bindPositiveWholeNumberValidation(normal, reduce, strategy, false);
            limits = this.text.minimumAndMaximumValue((long)converter.convertFrom(0.05), (long)converter.convertFrom(4.0), converter.getUnit());
        }
        this.setRestrictionsText(normal, reduce, limits);
    }

    @Override
    public void bindMaxTcpSpeed(NumberField normal, NumberField reduce) {
        this.bindMaxSpeed(normal, reduce, this.minToolSpeedValue, this.maxToolSpeedValue);
    }

    @Override
    public void bindMaxTcpForce(NumberField normal, NumberField reduce) {
        this.bindMaxForce(normal, reduce);
    }

    @Override
    public void bindMaxElbowSpeed(NumberField normal, NumberField reduce) {
        this.bindMaxSpeed(normal, reduce, this.minElbowSpeedValue, this.maxElbowSpeedValue);
    }

    private void bindMaxSpeed(NumberField normal, NumberField reduced, double minimumValue, double maximumValue) {
        String limits;
        UnitsConverter converter = Units.getMmPerSecondConverter();
        ValidationStrategy strategy = ValidationFactory.getRangeValidator((double)converter.convertFrom(minimumValue), (double)converter.convertFrom(maximumValue), (String)this.text.valueOutsideOfRange());
        if (Settings.getUnits().isUS()) {
            this.bindPositiveTo100thDecimalValidation(normal, reduced);
            limits = this.text.minimumAndMaximumValuesTo2Decimals(converter.convertFrom(minimumValue), converter.convertFrom(maximumValue), converter.getUnit());
            this.setErrorValidationStrategy(normal, reduced, strategy);
        } else {
            this.bindPositiveWholeNumberValidation(normal, reduced, strategy, false);
            limits = this.text.minimumAndMaximumValues(converter.convertFrom(minimumValue), converter.convertFrom(maximumValue), converter.getUnit());
        }
        this.setRestrictionsText(normal, reduced, limits);
    }

    @Override
    public void bindMaxElbowForce(NumberField normal, NumberField reduce) {
        this.bindMaxForce(normal, reduce);
    }

    private void bindMaxForce(NumberField normal, NumberField reduced) {
        String limits;
        UnitsConverter converter = Units.getNewtonsConverter();
        ValidationStrategy strategy = ValidationFactory.getRangeValidator((double)converter.convertFrom(this.minForceValue), (double)converter.convertFrom(this.maxForceValue), (String)this.text.valueOutsideOfRange());
        if (Settings.getUnits().isUS()) {
            this.bindPositiveTo100thDecimalValidation(normal, reduced);
            limits = this.text.minimumAndMaximumValuesTo2Decimals(converter.convertFrom(this.minForceValue), converter.convertFrom(this.maxForceValue), converter.getUnit());
            this.setErrorValidationStrategy(normal, reduced, strategy);
        } else {
            this.bindPositiveTo10thDecimalValidation(normal, reduced, strategy, true);
            limits = this.text.minimumAndMaximumValuesTo1Decimals(converter.convertFrom(this.minForceValue), converter.convertFrom(this.maxForceValue), converter.getUnit());
        }
        this.setRestrictionsText(normal, reduced, limits);
    }

    private void setRestrictionsText(NumberField normal, NumberField reduce, String limits) {
        normal.setRestrictionsText(limits);
        reduce.setRestrictionsText(limits);
    }

    private void bindPositiveWholeNumberValidation(NumberField normal, NumberField reduce, ValidationStrategy strategy, boolean allowReducedValueAbove) {
        normal.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0"));
        reduce.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0"));
        normal.setMode(Mode.PositiveWholeNumbers);
        reduce.setMode(Mode.PositiveWholeNumbers);
        this.setErrorValidationStrategyForWholeNumbers(normal, reduce, strategy, allowReducedValueAbove);
    }

    private void setErrorValidationStrategyForWholeNumbers(NumberField normal, NumberField reduce, ValidationStrategy strategy, boolean allowReduceValueAbove) {
        ValidationStrategy.Composite composite = new ValidationStrategy.Composite(new ValidationStrategy[]{strategy, ValidationFactory.getWholeNumberValidator()});
        if (allowReduceValueAbove) {
            normal.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getValueAboveValidationStrategy((NumberField)reduce, (String)this.text.valueMustBeEqualOrAboveReducedValue())});
            reduce.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getValueBelowValidationStrategy((NumberField)normal, (String)this.text.valueMustBeEqualOrBelowNormalValue())});
            normal.setErrorValidationStrategy(new ValidationStrategy[]{composite});
            reduce.setErrorValidationStrategy(new ValidationStrategy[]{composite});
        } else {
            normal.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getValueAboveValidationStrategy((NumberField)reduce, (String)this.text.valueMustBeEqualOrAboveReducedValue()), composite});
            reduce.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getValueBelowValidationStrategy((NumberField)normal, (String)this.text.valueMustBeEqualOrBelowNormalValue()), composite});
        }
    }

    private void setErrorValidationStrategy(NumberField normal, NumberField reduce, ValidationStrategy strategy) {
        normal.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getValueAboveValidationStrategy((NumberField)reduce, (String)this.text.valueMustBeEqualOrAboveReducedValue()), strategy});
        reduce.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getValueBelowValidationStrategy((NumberField)normal, (String)this.text.valueMustBeEqualOrBelowNormalValue()), strategy});
    }

    private void bindPositiveTo10thDecimalValidation(NumberField normal, NumberField reduce, ValidationStrategy strategy, boolean allowReduceValueAbove) {
        normal.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.0"));
        reduce.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.0"));
        normal.setMode(Mode.PositiveNumbers);
        reduce.setMode(Mode.PositiveNumbers);
        ValidationStrategy placement = ValidationFactory.getDecimalPlacesValidator((int)1);
        if (allowReduceValueAbove) {
            normal.setNonTypicalValidationStrategy(new ValidationStrategy[]{ValidationFactory.getValueAboveValidationStrategy((NumberField)reduce, (String)this.text.valueIsHigherInReducedThanNormal()), placement});
            reduce.setNonTypicalValidationStrategy(new ValidationStrategy[]{ValidationFactory.getValueBelowValidationStrategy((NumberField)normal, (String)this.text.valueIsHigherInReducedThanNormal()), placement});
            normal.setErrorValidationStrategy(new ValidationStrategy[]{strategy});
            reduce.setErrorValidationStrategy(new ValidationStrategy[]{strategy});
        } else {
            normal.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getValueAboveValidationStrategy((NumberField)reduce, (String)this.text.valueMustBeEqualOrAboveReducedValue()), strategy});
            reduce.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getValueBelowValidationStrategy((NumberField)normal, (String)this.text.valueMustBeEqualOrBelowNormalValue()), strategy});
            normal.setWarningValidationStrategy(new ValidationStrategy[]{placement});
            reduce.setWarningValidationStrategy(new ValidationStrategy[]{placement});
        }
    }

    private void bindPositiveTo100thDecimalValidation(NumberField normal, NumberField reduce) {
        normal.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.00"));
        reduce.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.00"));
        normal.setMode(Mode.PositiveNumbers);
        reduce.setMode(Mode.PositiveNumbers);
        normal.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getDecimalPlacesValidator((int)2)});
        reduce.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getDecimalPlacesValidator((int)2)});
    }
}

