/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.externalapi;

import com.ur.math.Force;
import com.ur.math.Length;
import com.ur.math.Momentum;
import com.ur.math.Power;
import com.ur.math.Speed;
import com.ur.math.Time;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.generallimits.core.Limit;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.generallimits.domain.GeneralLimitsMode;
import com.ur.safety.generallimits.externalapi.GeneralLimitsView;
import com.ur.safety.generallimits.service.GeneralLimitsService;
import com.ur.safety.impl.ReloadOnSafetyLoaded;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.swing.dialog.ConfirmationDialogListener;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GeneralLimitsPresenter
implements ReloadOnSafetyLoaded {
    private SafetyLimitsComponent component;
    private final SafetySettingsLookupService lookupService;
    private final EnableGeneralLimitsView enablement;
    private final GeneralLimitsService generalLimitsService;
    private GeneralLimitsView view;

    @Inject
    GeneralLimitsPresenter(SafetySettingsLookupService lookupService, EnableGeneralLimitsView enablement, GeneralLimitsService generalLimitsService) {
        this.lookupService = lookupService;
        this.enablement = enablement;
        this.generalLimitsService = generalLimitsService;
    }

    public void setView(GeneralLimitsView view) {
        this.view = view;
        this.enablement.setView(view);
        this.activate();
    }

    public void activate() {
        this.component = this.lookupService.getSafetyComponent(SafetyLimitsComponent.class);
        this.view.setReduceMode(this.lookupService.getSafetySetup().isReducedModeDefined());
        this.view.setBaseValues(this.component.getMaximumPower(), this.component.getMaximumMomentum(), this.component.getMaximumStoppingDistance(), this.component.getMaximumStoppingTime());
        this.view.setToolValues(this.component.getMaximumToolSpeed(), this.component.getMaximumToolForce());
        this.view.setElbowValues(this.component.getMaximumElbowSpeed(), this.component.getMaximumElbowForce());
        GeneralLimitsMode mode = this.generalLimitsService.getMode(this.component);
        this.view.selectGeneralLimitsMode(mode);
        this.enablement.updateEnablement();
    }

    public void deactivate() {
    }

    public void setPower(Limit<Power> power) {
        this.component.setMaximumPower(power);
    }

    public void setMomentum(Limit<Momentum> momentum) {
        this.component.setMaximumMomentum(momentum);
    }

    public void setStoppingTime(Limit<Time> stoppingTime) {
        this.component.setMaximumStoppingTime(stoppingTime);
    }

    public void setStoppingDistance(Limit<Length> stoppingDistance) {
        this.component.setMaximumStoppingDistance(stoppingDistance);
    }

    public void setToolSpeed(Limit<Speed> toolSpeed) {
        this.component.setMaximumToolSpeed(toolSpeed);
    }

    public void setToolForce(Limit<Force> toolForce) {
        this.component.setMaximumToolForce(toolForce);
    }

    public void setElbowSpeed(Limit<Speed> elbowSpeed) {
        this.component.setMaximumElbowSpeed(elbowSpeed);
    }

    public void setElbowForce(Limit<Force> elbowForce) {
        this.component.setMaximumElbowForce(elbowForce);
    }

    public void selectFactoryPreset() {
        GeneralLimitsMode mode = this.generalLimitsService.getMode(this.component);
        if (mode == GeneralLimitsMode.CUSTOMIZED_MODE) {
            this.setFactoryPreset(GeneralLimitsMode.DEFAULT_MODE);
        } else {
            this.setFactoryPreset(mode);
        }
    }

    public void confirmSwitchToFactoryPreset(ConfirmationDialogListener confirmationDialogListener) {
        GeneralLimitsMode mode = this.generalLimitsService.getMode(this.component);
        if (mode == GeneralLimitsMode.CUSTOMIZED_MODE) {
            this.view.informLossOfCustomizedSettings(confirmationDialogListener);
        } else {
            confirmationDialogListener.onOkClicked();
        }
    }

    public void setFactoryPreset(GeneralLimitsMode mode) {
        this.generalLimitsService.applyPreset(mode, this.component);
        this.activate();
    }

    @Override
    public void reset() {
        this.activate();
    }

    @Singleton
    static class EnableGeneralLimitsView
    implements SafetyLockListener {
        private GeneralLimitsView view;
        private final SafetyLock safetyLock;

        @Inject
        EnableGeneralLimitsView(SafetyLock safetyLock) {
            this.safetyLock = safetyLock;
            safetyLock.addSafetyLockListener(this);
        }

        public void setView(GeneralLimitsView view) {
            this.view = view;
            this.updateEnablement();
        }

        public void updateEnablement() {
            this.view.enableInputs(!this.safetyLock.isLocked());
        }

        @Override
        public void doUnlock() {
            this.view.enableInputs(true);
        }

        @Override
        public void doLock() {
            this.view.enableInputs(false);
        }
    }
}

