/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.externalapi;

import com.ur.math.Speed;
import com.ur.polyscope.viewfacade.safety.SafetyLimitsProvider;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.generallimits.core.Limit;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import javax.inject.Inject;

public class SafetyLimitsProviderImpl
implements SafetyLimitsProvider {
    private final SafetySettingsLookupService safetySettingsLookupService;

    @Inject
    private SafetyLimitsProviderImpl(SafetySettingsLookupService safetySettingsLookupService) {
        this.safetySettingsLookupService = safetySettingsLookupService;
    }

    public double getMaxToolForce() {
        SafetyLimitsComponent component = (SafetyLimitsComponent)this.safetySettingsLookupService.getSafetySetup().getComponent(SafetyLimitsComponent.class);
        return Math.max(component.getNormalLimits().getMaxToolForce(), component.getReducedLimits().getMaxToolForce()) - this.safetySettingsLookupService.getSafetyComplianceTolerances().getForceTolerance();
    }

    public double getMaxToolSpeed() {
        SafetyLimitsComponent component = this.safetySettingsLookupService.getSafetyComponent(SafetyLimitsComponent.class);
        Limit<Speed> maximumToolSpeed = component.getMaximumToolSpeed();
        return maximumToolSpeed.getNormalValue().asDouble();
    }
}

