/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.infrastructure;

import com.ur.lang.PrimitiveUtils;
import com.ur.math.Force;
import com.ur.math.Length;
import com.ur.math.Momentum;
import com.ur.math.NumberValue;
import com.ur.math.Power;
import com.ur.math.Speed;
import com.ur.math.Time;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.AbstractSafetySetupToHtmlRenderer;
import com.ur.safety.HTMLPage;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.SafetySetupPanesLookAndFeel;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.generallimits.core.Limit;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.util.domain.AlternatingBackgroundRowGenerator;
import com.ur.swing.units.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import com.ur.util.ArrayUtils;
import com.ur.util.swing.HTML;
import java.text.Format;
import java.util.Arrays;
import javax.inject.Inject;

public class GeneralLimitsHtmlRenderer
extends AbstractSafetySetupToHtmlRenderer {
    private ValueConverter<String, Force> forceConverter;
    private ValueConverter<String, Power> powerConverter;
    private ValueConverter<String, Speed> speedConverter;
    private ValueConverter<String, Momentum> momentumConverter;
    private ValueConverter<String, Time> timeConverter;
    private ValueConverter<String, Length> distanceConverter;

    @Inject
    public GeneralLimitsHtmlRenderer(SafetyTextResource translation, SafetySetupPanesLookAndFeel lookAndFeel) {
        super(translation, lookAndFeel);
    }

    @Override
    public HTMLPage createContributedPage(SafetySetup safetySetup, boolean useSIUnits) {
        String pageTitle = this.textResource.safetyTabRobotLimits();
        if (safetySetup.isReducedModeDefined() || useSIUnits) {
            return new HTMLPage(pageTitle, this.presentAsHTML((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class), useSIUnits, SafetyLimitMode.NORMAL, SafetyLimitMode.REDUCED));
        }
        return new HTMLPage(pageTitle, this.presentAsHTML((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class), useSIUnits, SafetyLimitMode.NORMAL));
    }

    private String presentAsHTML(SafetyLimitsComponent component, boolean useSIUnits, SafetyLimitMode ... modes) {
        this.powerConverter = UnitsValueConverterFactory.getPowerConverter((boolean)useSIUnits);
        this.momentumConverter = UnitsValueConverterFactory.getMomentumConverter((boolean)useSIUnits);
        this.timeConverter = UnitsValueConverterFactory.getTimeConverter((boolean)useSIUnits);
        this.distanceConverter = UnitsValueConverterFactory.getLengthConverter((boolean)useSIUnits);
        this.speedConverter = UnitsValueConverterFactory.getSpeedConverter((boolean)useSIUnits);
        this.forceConverter = UnitsValueConverterFactory.getForceConverter((boolean)useSIUnits);
        boolean includeReducedMode = ArrayUtils.contains((Object)((Object)SafetyLimitMode.REDUCED), (Object[])modes);
        return this.generateGeneralLimits(component, includeReducedMode);
    }

    private String generateGeneralLimits(SafetyLimitsComponent component, boolean includeReducedMode) {
        AlternatingBackgroundRowGenerator rowGenerator = new AlternatingBackgroundRowGenerator();
        return HTML.table((int)this.lookAndFeel.panelWidth, (String[])new String[]{this.headerRow(includeReducedMode), rowGenerator.generate(this.limitRow(this.textResource.power(), component.getMaximumPower(), this.powerConverter, includeReducedMode)), rowGenerator.generate(this.limitRow(this.textResource.momentum(), component.getMaximumMomentum(), this.momentumConverter, includeReducedMode)), rowGenerator.generate(this.limitRow(this.textResource.stoppingTime(), component.getMaximumStoppingTime(), this.timeConverter, includeReducedMode)), rowGenerator.generate(this.limitRow(this.textResource.stoppingDistance(), component.getMaximumStoppingDistance(), this.distanceConverter, includeReducedMode)), rowGenerator.generate(this.limitRow(this.textResource.tcpSpeed(), component.getMaximumToolSpeed(), this.speedConverter, includeReducedMode)), rowGenerator.generate(this.limitRow(this.textResource.tcpForce(), component.getMaximumToolForce(), this.forceConverter, includeReducedMode)), rowGenerator.generate(this.limitRow(this.textResource.elbowSpeed(), component.getMaximumElbowSpeed(), this.speedConverter, includeReducedMode)), rowGenerator.generate(this.limitRow(this.textResource.elbowForce(), component.getMaximumElbowForce(), this.forceConverter, includeReducedMode))});
    }

    private String headerRow(boolean includeReducedMode) {
        if (includeReducedMode) {
            return HTML.tableRow((String[])new String[]{HTML.tableHeaderWithProperties((String)"align=left", (String)this.textResource.safetyHeaderLimit()), HTML.tableHeaderWithProperties((String)"align=right", (String)this.textResource.normal()), HTML.tableHeaderWithProperties((String)"align=center colspan=2 nowrap", (String)this.textResource.reduced())});
        }
        return HTML.tableRow((String[])new String[]{HTML.tableHeaderWithProperties((String)"align=left", (String)this.textResource.safetyHeaderLimit()), HTML.tableHeaderWithProperties((String)"align=center colspan=2 nowrap", (String)this.textResource.normal())});
    }

    private <T extends NumberValue> Iterable<String> limitRow(String label, Limit<T> value, ValueConverter<String, T> converter, boolean includeReducedMode) {
        String normalValue = (String)converter.fromModel(value.getNormalValue());
        if (includeReducedMode) {
            String reducedValue = (String)converter.fromModel(value.getReducedValue());
            return Arrays.asList(HTML.tableCell((String)label), HTML.tableCellNumber((String)this.formatValue(converter.getFormat(), normalValue)), HTML.tableCellNumber((String)this.formatValue(converter.getFormat(), reducedValue)), HTML.tableCell((String)converter.getUnit()));
        }
        return Arrays.asList(HTML.tableCell((String)label), HTML.tableCellNumber((String)this.formatValue(converter.getFormat(), normalValue)), HTML.tableCell((String)converter.getUnit()));
    }

    private String formatValue(Format format, String value) {
        double doubleValue = PrimitiveUtils.parseDouble((String)value, (double)0.0);
        return format.format(doubleValue);
    }
}

