/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.infrastructure;

import com.ur.math.NumberValue;
import com.ur.safety.generallimits.core.Limit;
import com.ur.swing.WidgetFactory;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.units.ValueConverter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;

abstract class NormalAndReduceInput<T extends NumberValue> {
    public static final boolean ALLOW = true;
    public static final boolean DISALLOW = false;
    protected final UnitsConverter converter;
    final NumberField normal;
    final NumberField reduce;
    private final ReduceActionListener reduceActionListener;
    private final NormalActionListener normalActionListener;
    private final boolean allowNormalBelowReducedValue;
    private boolean reducedEnabled;

    protected NormalAndReduceInput(WidgetFactory widgetFactory, UnitsConverter unit, ValueConverter valueConverter) {
        this(widgetFactory, unit, valueConverter, false);
    }

    protected NormalAndReduceInput(WidgetFactory widgetFactory, UnitsConverter unit, ValueConverter valueConverter, boolean allowNormalBelowReducedValue) {
        this.converter = unit;
        this.allowNormalBelowReducedValue = allowNormalBelowReducedValue;
        this.normalActionListener = new NormalActionListener();
        this.normal = widgetFactory.createNumberField((ActionListener)this.normalActionListener, valueConverter);
        this.reduceActionListener = new ReduceActionListener();
        this.reduce = widgetFactory.createNumberField((ActionListener)this.reduceActionListener, valueConverter);
        this.normal.setUnitWidth(55);
        this.reduce.setUnitWidth(55);
    }

    public void setEnabled(boolean enabled) {
        this.normal.setEnabled(enabled);
        this.reduce.setEnabled(enabled && this.reducedEnabled);
        this.normal.forceValidation();
    }

    public void setReducedEnabled(boolean reducedEnabled) {
        this.reducedEnabled = reducedEnabled;
        this.reduce.setEnabled(this.normal.isEnabled() && reducedEnabled);
    }

    void setValue(Limit<T> value) {
        this.normal.removeActionListener((ActionListener)this.normalActionListener);
        this.reduce.removeActionListener((ActionListener)this.reduceActionListener);
        this.normal.setValue(value.getNormalValue());
        this.reduce.setValue(value.getReducedValue());
        this.normal.addActionListener((ActionListener)this.normalActionListener);
        this.reduce.addActionListener((ActionListener)this.reduceActionListener);
    }

    abstract void updateValue(Limit<T> var1);

    private boolean normalValueIsBelowReduceValue() {
        return this.parseDoubleValue(this.normal) < this.parseDoubleValue(this.reduce);
    }

    private Double parseDoubleValue(NumberField numberField) {
        try {
            Number number = NumberFormat.getNumberInstance().parse(numberField.getText());
            return number.doubleValue();
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(numberField.getText());
        }
    }

    private class NormalActionListener
    implements ActionListener {
        private NormalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!NormalAndReduceInput.this.allowNormalBelowReducedValue && NormalAndReduceInput.this.normalValueIsBelowReduceValue()) {
                NormalAndReduceInput.this.reduce.setText(NormalAndReduceInput.this.normal.getText());
            }
            NormalAndReduceInput.this.reduce.forceValidation();
            NormalAndReduceInput.this.normal.forceValidation();
            NormalAndReduceInput.this.updateValue(new Limit<NumberValue>((NumberValue)NormalAndReduceInput.this.normal.getValue(), (NumberValue)NormalAndReduceInput.this.reduce.getValue()));
        }
    }

    private class ReduceActionListener
    implements ActionListener {
        private ReduceActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NormalAndReduceInput.this.reduce.forceValidation();
            NormalAndReduceInput.this.normal.forceValidation();
            NormalAndReduceInput.this.updateValue(new Limit<NumberValue>((NumberValue)NormalAndReduceInput.this.normal.getValue(), (NumberValue)NormalAndReduceInput.this.reduce.getValue()));
        }
    }
}

