/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.infrastructure;

import com.ur.lang.BijectiveEnumMap;
import com.ur.math.Force;
import com.ur.math.Length;
import com.ur.math.Momentum;
import com.ur.math.Power;
import com.ur.math.Speed;
import com.ur.math.Time;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.polyscope.viewfacade.lang.ShowIcon;
import com.ur.resources.ViewImageResource;
import com.ur.safety.Safety;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.Settings;
import com.ur.safety.generallimits.core.Limit;
import com.ur.safety.generallimits.domain.GeneralLimitsMode;
import com.ur.safety.generallimits.externalapi.GeneralLimitsInputBinder;
import com.ur.safety.generallimits.externalapi.GeneralLimitsPresenter;
import com.ur.safety.generallimits.externalapi.GeneralLimitsView;
import com.ur.safety.generallimits.infrastructure.GeneralLimitsPanel;
import com.ur.safety.generallimits.infrastructure.NormalAndReduceInput;
import com.ur.safety.util.infrastructure.SimpleSwingFormValidation;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.number.OnEditListener;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsValueConverterFactory;
import com.ur.util.swing.HTML;
import gui.tools.DialogCreator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RobotLimitsPanel
extends GeneralLimitsPanel
implements GeneralLimitsView {
    public static final String CUSTOM_SETTINGS_RADIO_BUTTON = "customSettingsRadioButton." + RobotLimitsPanel.class.getSimpleName();
    public static final String FACTORY_PRESET_RADIO_BUTTON = "factoryPresetRadioButton." + RobotLimitsPanel.class.getSimpleName();
    private static final Color BETWEEN_CARD_COLOR = UIManager.getColor("CardPanel.background");
    private static final BijectiveEnumMap<GeneralLimitsMode, Integer> SLIDER_POSITION = new BijectiveEnumMap(GeneralLimitsMode.class).put((Enum)GeneralLimitsMode.MOST_RESTRICTED_MODE, (Object)0).put((Enum)GeneralLimitsMode.RESTRICTED_MODE, (Object)1).put((Enum)GeneralLimitsMode.DEFAULT_MODE, (Object)2).put((Enum)GeneralLimitsMode.LEAST_RESTRICTED_MODE, (Object)3).put((Enum)GeneralLimitsMode.CUSTOMIZED_MODE, (Object)-1).seal();
    private final GeneralLimitsInputBinder inputBinder;
    private final ViewContext view;
    private final GeneralLimitsPresenter presenter;
    private final DialogCreator dialogCreator;
    private SelectMode selectMode;
    private LimitsSelection limitsSelection;
    private MaxPower power;
    private MaxMomentum momentum;
    private MaxStoppingTime stoppingTime;
    private MaxStoppingDistance stoppingDistance;
    private MaxTcpSpeed tcpSpeed;
    private MaxTcpForce tcpForce;
    private MaxElbowSpeed elbowSpeed;
    private MaxElbowForce elbowForce;
    private JLabel image;
    private final HelpIdAssigner helpIdAssigner;
    private SafetyTextResource textResource;

    @Inject
    private RobotLimitsPanel(GeneralLimitsPresenter presenter, @Safety ShowIcon showIcon, GeneralLimitsInputBinder inputBinder, ViewContext view, HelpIdAssigner helpIdAssigner, DialogCreator dialogCreator) {
        this.inputBinder = inputBinder;
        this.view = view;
        this.presenter = presenter;
        SimpleSwingFormValidation formValidation = new SimpleSwingFormValidation(this, showIcon);
        this.helpIdAssigner = helpIdAssigner;
        this.textResource = (SafetyTextResource)view.getTextResource(SafetyTextResource.class);
        this.dialogCreator = dialogCreator;
        this.initComponents(view);
        this.initValidation(formValidation);
        presenter.setView(this);
    }

    private void initValidation(SimpleSwingFormValidation formValidation) {
        formValidation.addComponent(this.power.normal);
        formValidation.addComponent(this.momentum.normal);
        formValidation.addComponent(this.stoppingTime.normal);
        formValidation.addComponent(this.stoppingDistance.normal);
        formValidation.addComponent(this.tcpSpeed.normal);
        formValidation.addComponent(this.tcpForce.normal);
        formValidation.addComponent(this.elbowSpeed.normal);
        formValidation.addComponent(this.elbowForce.normal);
        formValidation.addComponent(this.power.reduce);
        formValidation.addComponent(this.momentum.reduce);
        formValidation.addComponent(this.stoppingTime.reduce);
        formValidation.addComponent(this.stoppingDistance.reduce);
        formValidation.addComponent(this.tcpSpeed.reduce);
        formValidation.addComponent(this.tcpForce.reduce);
        formValidation.addComponent(this.elbowSpeed.reduce);
        formValidation.addComponent(this.elbowForce.reduce);
    }

    @Override
    public void activate() {
        if (Settings.isRunningInDevelopmentMode()) {
            this.removeAll();
            this.initComponents(this.view);
        }
        this.presenter.activate();
    }

    @Override
    public void deactivate() {
        this.presenter.deactivate();
    }

    private void initComponents(ViewContext view) {
        WidgetFactory widgetFactory = view.createWidgetFactory();
        this.setBackground(BETWEEN_CARD_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)widgetFactory.withTitle(view.createFormBuilder().label(HTML.html((String)this.textResource.alwaysMakeRiskAssessment()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end().end().getPanel(), ViewImageResource.formWarning(), this.textResource.danger()), "North");
        this.limitsSelection = new LimitsSelection(this.textResource);
        this.power = new MaxPower(widgetFactory, this.inputBinder);
        this.momentum = new MaxMomentum(widgetFactory, this.inputBinder);
        this.stoppingTime = new MaxStoppingTime(widgetFactory, this.inputBinder);
        this.stoppingDistance = new MaxStoppingDistance(widgetFactory, this.inputBinder);
        this.tcpSpeed = new MaxTcpSpeed(widgetFactory, this.inputBinder);
        this.tcpForce = new MaxTcpForce(widgetFactory, this.inputBinder);
        this.elbowSpeed = new MaxElbowSpeed(widgetFactory, this.inputBinder);
        this.elbowForce = new MaxElbowForce(widgetFactory, this.inputBinder);
        this.selectMode = new SelectMode(this.textResource, widgetFactory, this.limitsSelection, this.power, this.momentum, this.stoppingTime, this.stoppingDistance, this.tcpSpeed, this.tcpForce, this.elbowSpeed, this.elbowForce);
        this.image = new JLabel();
        this.image.setIcon(ViewImageResource.safetyAllParts());
        JPanel selection = view.createFormBuilder().component((JComponent)this.selectMode.factoryPresets, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.limitsSelection.slider, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).spacer().end(2).getPanel();
        JPanel definedLimits = view.createFormBuilder().component((JComponent)this.selectMode.customizeSettings, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).component((JComponent)this.image, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.FILL_ROWS}).end(2).columnTitle(this.textResource.safetyHeaderLimit(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).columnTitle(this.textResource.normal(), new FormBuilder.PanelConstraints[0]).columnTitle(this.textResource.reduced(), new FormBuilder.PanelConstraints[0]).end().label(this.textResource.power(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.power.normal, new FormBuilder.PanelConstraints[0]).component((JComponent)this.power.reduce, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.momentum(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.momentum.normal, new FormBuilder.PanelConstraints[0]).component((JComponent)this.momentum.reduce, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.stoppingTime(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.stoppingTime.normal, new FormBuilder.PanelConstraints[0]).component((JComponent)this.stoppingTime.reduce, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.stoppingDistance(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.stoppingDistance.normal, new FormBuilder.PanelConstraints[0]).component((JComponent)this.stoppingDistance.reduce, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.tcpSpeed(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.tcpSpeed.normal, new FormBuilder.PanelConstraints[0]).component((JComponent)this.tcpSpeed.reduce, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.tcpForce(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.tcpForce.normal, new FormBuilder.PanelConstraints[0]).component((JComponent)this.tcpForce.reduce, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.elbowSpeed(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.elbowSpeed.normal, new FormBuilder.PanelConstraints[0]).component((JComponent)this.elbowSpeed.reduce, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.elbowForce(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.elbowForce.normal, new FormBuilder.PanelConstraints[0]).component((JComponent)this.elbowForce.reduce, new FormBuilder.PanelConstraints[0]).end().groupColumns(new int[]{1, 3, 4, 6}).getPanel();
        definedLimits.setPreferredSize(new Dimension(0, 380));
        this.add((Component)selection, "Center");
        this.add((Component)definedLimits, "South");
        this.helpIdAssigner.assignHelpId((JComponent)selection, "gui:installation_safety_factory_presets");
        this.helpIdAssigner.assignHelpId((JComponent)definedLimits, "gui:installation_safety_custom");
    }

    @Override
    public void selectGeneralLimitsMode(GeneralLimitsMode mode) {
        if (mode == GeneralLimitsMode.CUSTOMIZED_MODE) {
            this.selectMode.selectCustomizeSettings();
        } else {
            this.selectMode.selectFactoryPresets();
            this.limitsSelection.setGeneralLimitsMode(mode);
            this.image.setIcon(ViewImageResource.safetyAllParts());
        }
    }

    @Override
    public void setReduceMode(boolean reducedModeDefined) {
        this.selectMode.setReducedMode(reducedModeDefined);
    }

    @Override
    public void setBaseValues(Limit<Power> powerValue, Limit<Momentum> momentumValue, Limit<Length> stoppingDistanceValue, Limit<Time> stoppingTimeValue) {
        this.power.setValue(powerValue);
        this.momentum.setValue(momentumValue);
        this.stoppingTime.setValue(stoppingTimeValue);
        this.stoppingDistance.setValue(stoppingDistanceValue);
    }

    @Override
    public void setToolValues(Limit<Speed> speed, Limit<Force> force) {
        this.tcpSpeed.setValue(speed);
        this.tcpForce.setValue(force);
    }

    @Override
    public void setElbowValues(Limit<Speed> speed, Limit<Force> force) {
        this.elbowSpeed.setValue(speed);
        this.elbowForce.setValue(force);
    }

    @Override
    public void enableInputs(boolean enablementState) {
        this.selectMode.setEnabled(enablementState);
    }

    private ConfirmationMessage confirmCustomizedSafetyLimitsWillBeLost() {
        return new ConfirmationMessage(DialogWithName.CLEAR_CUSTOMIZED_SAFETY_LIMITS.getName(), this.textResource.confirmCustomizedSafetyLimitsWillBeLostTitle(), this.textResource.confirmCustomizedSafetyLimitsWillBeLostExplanation(), this.textResource.confirmCustomizedSafetyLimitsWillBeLostAction(), this.textResource.Cancel());
    }

    @Override
    public void informLossOfCustomizedSettings(ConfirmationDialogListener confirmationDialogListener) {
        this.dialogCreator.showConfirmationDialog(this.confirmCustomizedSafetyLimitsWillBeLost(), confirmationDialogListener);
    }

    @Override
    public Errorable.Status getStatus() {
        return Errorable.Status.OK;
    }

    @Override
    public void addStatusListener(Errorable.StatusListener listener) {
    }

    @Override
    public void removeStatusListener(Errorable.StatusListener listener) {
    }

    private class LimitsSelection
    implements ChangeListener {
        private final JSlider slider = new JSlider(0);

        public LimitsSelection(SafetyTextResource text) {
            Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
            ((Dictionary)sliderLabels).put(0, new JLabel(text.mostRestricted()));
            ((Dictionary)sliderLabels).put(3, new JLabel(text.leastRestricted()));
            this.slider.setName(GeneralLimitsPanel.LIMITS_MODE_SELECTOR);
            this.slider.setLabelTable(sliderLabels);
            this.slider.setMajorTickSpacing(1);
            this.slider.setMinimum(0);
            this.slider.setMaximum(3);
            this.slider.setPaintLabels(true);
            this.slider.setPaintTicks(true);
            this.slider.setSnapToTicks(true);
            this.slider.putClientProperty("JSlider.isFilled", false);
            this.slider.addChangeListener(this);
        }

        public void setEnabled(boolean enabled) {
            this.slider.setEnabled(enabled);
        }

        public void setShowTick(boolean showTick) {
            this.slider.putClientProperty("URSlider.ShowThumb", showTick);
        }

        public void setActive(boolean active) {
            this.setEnabled(active);
            this.setShowTick(active);
        }

        public void setGeneralLimitsMode(GeneralLimitsMode mode) {
            this.slider.setValue((Integer)SLIDER_POSITION.getValue((Enum)mode));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            RobotLimitsPanel.this.presenter.setFactoryPreset((GeneralLimitsMode)SLIDER_POSITION.getKey((Object)this.slider.getValue()));
        }
    }

    private class MaxElbowForce
    extends NormalAndReduceInput<Force>
    implements OnEditListener {
        public MaxElbowForce(WidgetFactory widgetFactory, GeneralLimitsInputBinder inputBinder) {
            super(widgetFactory, Units.getNewtonsConverter(), UnitsValueConverterFactory.getForceConverter(), true);
            inputBinder.bindMaxElbowForce(this.normal, this.reduce);
            this.normal.setName(GeneralLimitsPanel.ELBOW_FORCE_NORMAL_MODE);
            this.reduce.setName(GeneralLimitsPanel.ELBOW_FORCE_REDUCE_MODE);
            this.normal.addOnEditListener((OnEditListener)this);
            this.reduce.addOnEditListener((OnEditListener)this);
        }

        @Override
        void updateValue(Limit<Force> newValue) {
            RobotLimitsPanel.this.presenter.setElbowForce(newValue);
        }

        public void requestEdit() {
            RobotLimitsPanel.this.image.setIcon(ViewImageResource.safetyElbow());
        }
    }

    private class MaxElbowSpeed
    extends NormalAndReduceInput<Speed>
    implements OnEditListener {
        public MaxElbowSpeed(WidgetFactory widgetFactory, GeneralLimitsInputBinder inputBinder) {
            super(widgetFactory, Units.getMmPerSecondConverter(), UnitsValueConverterFactory.getSpeedConverter());
            inputBinder.bindMaxElbowSpeed(this.normal, this.reduce);
            this.normal.setName(GeneralLimitsPanel.ELBOW_SPEED_NORMAL_MODE);
            this.reduce.setName(GeneralLimitsPanel.ELBOW_SPEED_REDUCED_MODE);
            this.normal.addOnEditListener((OnEditListener)this);
            this.reduce.addOnEditListener((OnEditListener)this);
        }

        @Override
        void updateValue(Limit<Speed> newValue) {
            RobotLimitsPanel.this.presenter.setElbowSpeed(newValue);
        }

        public void requestEdit() {
            RobotLimitsPanel.this.image.setIcon(ViewImageResource.safetyElbow());
        }
    }

    private class MaxMomentum
    extends NormalAndReduceInput<Momentum>
    implements OnEditListener {
        public MaxMomentum(WidgetFactory widgetFactory, GeneralLimitsInputBinder inputBinder) {
            super(widgetFactory, Units.getKgMsConverter(), UnitsValueConverterFactory.getMomentumConverter());
            inputBinder.bindMaxMomentum(this.normal, this.reduce);
            this.normal.setName(GeneralLimitsPanel.MOMENTUM_NORMAL_MODE);
            this.reduce.setName(GeneralLimitsPanel.MOMENTUM_REDUCED_MODE);
            this.normal.addOnEditListener((OnEditListener)this);
            this.reduce.addOnEditListener((OnEditListener)this);
        }

        @Override
        void updateValue(Limit<Momentum> newValue) {
            RobotLimitsPanel.this.presenter.setMomentum(newValue);
        }

        public void requestEdit() {
            RobotLimitsPanel.this.image.setIcon(ViewImageResource.safetyMomentum());
        }
    }

    private class MaxPower
    extends NormalAndReduceInput<Power>
    implements OnEditListener {
        public MaxPower(WidgetFactory widgetFactory, GeneralLimitsInputBinder inputBinder) {
            super(widgetFactory, Units.getWattConverter(), UnitsValueConverterFactory.getPowerConverter(), true);
            inputBinder.bindMaxPower(this.normal, this.reduce);
            this.normal.setName(GeneralLimitsPanel.POWER_NORMAL_MODE);
            this.reduce.setName(GeneralLimitsPanel.POWER_REDUCED_MODE);
            this.normal.addOnEditListener((OnEditListener)this);
            this.reduce.addOnEditListener((OnEditListener)this);
        }

        @Override
        void updateValue(Limit<Power> newValue) {
            RobotLimitsPanel.this.presenter.setPower(newValue);
        }

        public void requestEdit() {
            RobotLimitsPanel.this.image.setIcon(ViewImageResource.safetyMomentum());
        }
    }

    private class MaxStoppingDistance
    extends NormalAndReduceInput<Length>
    implements OnEditListener {
        public MaxStoppingDistance(WidgetFactory widgetFactory, GeneralLimitsInputBinder inputBinder) {
            super(widgetFactory, Units.getMetersConverter(), UnitsValueConverterFactory.getLengthConverter());
            inputBinder.bindMaxStoppingDistance(this.normal, this.reduce);
            this.normal.setName(GeneralLimitsPanel.STOPPING_DISTANCE_NORMAL_MODE);
            this.reduce.setName(GeneralLimitsPanel.STOPPING_DISTANCE_REDUCED_MODE);
            this.normal.addOnEditListener((OnEditListener)this);
            this.reduce.addOnEditListener((OnEditListener)this);
        }

        @Override
        void updateValue(Limit<Length> newValue) {
            RobotLimitsPanel.this.presenter.setStoppingDistance(newValue);
        }

        public void requestEdit() {
            RobotLimitsPanel.this.image.setIcon(ViewImageResource.safetyMomentum());
        }
    }

    private class MaxStoppingTime
    extends NormalAndReduceInput<Time>
    implements OnEditListener {
        public MaxStoppingTime(WidgetFactory widgetFactory, GeneralLimitsInputBinder inputBinder) {
            super(widgetFactory, Units.getTimeConverter(), UnitsValueConverterFactory.getTimeConverter());
            inputBinder.bindMaxStoppingTime(this.normal, this.reduce);
            this.normal.setName(GeneralLimitsPanel.STOPPING_TIME_NORMAL_MODE);
            this.reduce.setName(GeneralLimitsPanel.STOPPING_TIME_REDUCED_MODE);
            this.normal.addOnEditListener((OnEditListener)this);
            this.reduce.addOnEditListener((OnEditListener)this);
        }

        @Override
        void updateValue(Limit<Time> newValue) {
            RobotLimitsPanel.this.presenter.setStoppingTime(newValue);
        }

        public void requestEdit() {
            RobotLimitsPanel.this.image.setIcon(ViewImageResource.safetyMomentum());
        }
    }

    private class MaxTcpForce
    extends NormalAndReduceInput<Force>
    implements OnEditListener {
        public MaxTcpForce(WidgetFactory widgetFactory, GeneralLimitsInputBinder inputBinder) {
            super(widgetFactory, Units.getNewtonsConverter(), UnitsValueConverterFactory.getForceConverter(), true);
            inputBinder.bindMaxTcpForce(this.normal, this.reduce);
            this.normal.setName(GeneralLimitsPanel.FORCE_NORMAL_MODE);
            this.reduce.setName(GeneralLimitsPanel.FORCE_REDUCED_MODE);
            this.normal.addOnEditListener((OnEditListener)this);
            this.reduce.addOnEditListener((OnEditListener)this);
        }

        @Override
        void updateValue(Limit<Force> newValue) {
            RobotLimitsPanel.this.presenter.setToolForce(newValue);
        }

        public void requestEdit() {
            RobotLimitsPanel.this.image.setIcon(ViewImageResource.safetyTCP());
        }
    }

    private class MaxTcpSpeed
    extends NormalAndReduceInput<Speed>
    implements OnEditListener {
        public MaxTcpSpeed(WidgetFactory widgetFactory, GeneralLimitsInputBinder inputBinder) {
            super(widgetFactory, Units.getMmPerSecondConverter(), UnitsValueConverterFactory.getSpeedConverter());
            inputBinder.bindMaxTcpSpeed(this.normal, this.reduce);
            this.normal.setName(GeneralLimitsPanel.SPEED_NORMAL_MODE);
            this.reduce.setName(GeneralLimitsPanel.SPEED_REDUCED_MODE);
            this.normal.addOnEditListener((OnEditListener)this);
            this.reduce.addOnEditListener((OnEditListener)this);
        }

        @Override
        void updateValue(Limit<Speed> newValue) {
            RobotLimitsPanel.this.presenter.setToolSpeed(newValue);
        }

        public void requestEdit() {
            RobotLimitsPanel.this.image.setIcon(ViewImageResource.safetyTCP());
        }
    }

    private class SelectMode {
        final JRadioButton factoryPresets;
        final JRadioButton customizeSettings;
        private final LimitsSelection limitsSelection;
        private final NormalAndReduceInput[] inputs;

        public SelectMode(SafetyTextResource text, WidgetFactory widgetFactory, LimitsSelection limitsSelection, NormalAndReduceInput ... inputs) {
            this.limitsSelection = limitsSelection;
            this.inputs = inputs;
            this.factoryPresets = widgetFactory.createRadioButton((Action)((Object)new FactoryPresetAction(text)));
            this.customizeSettings = widgetFactory.createRadioButton((Action)((Object)new CustomSettingsAction(text)));
            this.customizeSettings.setName(CUSTOM_SETTINGS_RADIO_BUTTON);
            this.factoryPresets.setName(FACTORY_PRESET_RADIO_BUTTON);
            ButtonGroup group = new ButtonGroup();
            group.add(this.factoryPresets);
            group.add(this.customizeSettings);
        }

        public void selectFactoryPresets() {
            if (!this.factoryPresets.isSelected()) {
                this.factoryPresets.setSelected(true);
                this.factoryPresets.doClick();
            }
        }

        public void selectCustomizeSettings() {
            if (!this.customizeSettings.isSelected()) {
                this.customizeSettings.setSelected(true);
                this.customizeSettings.doClick();
            }
        }

        public void setEnabled(boolean enabled) {
            this.factoryPresets.setEnabled(enabled);
            this.customizeSettings.setEnabled(enabled);
            this.limitsSelection.setEnabled(enabled && this.factoryPresets.isSelected());
            this.limitsSelection.setShowTick(this.factoryPresets.isSelected());
            NormalAndReduceInput[] normalAndReduceInputArray = this.inputs;
            int n = this.inputs.length;
            int n2 = 0;
            while (n2 < n) {
                NormalAndReduceInput each = normalAndReduceInputArray[n2];
                each.setEnabled(enabled && this.customizeSettings.isSelected());
                ++n2;
            }
        }

        public void setReducedMode(boolean reducedMode) {
            NormalAndReduceInput[] normalAndReduceInputArray = this.inputs;
            int n = this.inputs.length;
            int n2 = 0;
            while (n2 < n) {
                NormalAndReduceInput each = normalAndReduceInputArray[n2];
                each.setReducedEnabled(reducedMode);
                ++n2;
            }
        }

        private class CustomSettingsAction
        extends AbstractActionDefinition {
            public CustomSettingsAction(SafetyTextResource text) {
                this.putValue("Name", text.custom());
            }

            public void actionPerformed(ActionEvent e) {
                SelectMode.this.limitsSelection.setActive(false);
                NormalAndReduceInput[] normalAndReduceInputArray = SelectMode.this.inputs;
                int n = normalAndReduceInputArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NormalAndReduceInput each = normalAndReduceInputArray[n2];
                    each.setEnabled(this.enabled);
                    ++n2;
                }
            }
        }

        private class FactoryPresetAction
        extends AbstractActionDefinition {
            public FactoryPresetAction(SafetyTextResource text) {
                this.putValue("Name", text.factoryPresets());
            }

            public void actionPerformed(ActionEvent e) {
                ConfirmationDialogListener listener = new ConfirmationDialogListener(){

                    public void onOkClicked() {
                        NormalAndReduceInput[] normalAndReduceInputArray = SelectMode.this.inputs;
                        int n = normalAndReduceInputArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            NormalAndReduceInput each = normalAndReduceInputArray[n2];
                            each.normal.setEnabled(false);
                            each.reduce.setEnabled(false);
                            ++n2;
                        }
                        RobotLimitsPanel.this.presenter.selectFactoryPreset();
                        SelectMode.this.limitsSelection.setActive(FactoryPresetAction.this.enabled);
                    }

                    public void onCancelClicked() {
                        SelectMode.this.selectCustomizeSettings();
                    }
                };
                RobotLimitsPanel.this.presenter.confirmSwitchToFactoryPreset(listener);
            }
        }
    }
}

